/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;
import org.wso2.carbon.usage.agent.listeners.UsageStatsAxis2ConfigurationContextObserver;
import org.wso2.carbon.usage.agent.util.PublisherUtils;
import org.wso2.carbon.usage.agent.util.Util;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.usage.agent", immediate=true)
public class UsageAgentServiceComponent {
    private static Log log = LogFactory.getLog(UsageAgentServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("wso2.system.user");
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setUserRealm((UserRealm)Util.getRealmService().getBootstrapRealm());
            Util.initializeAllListeners();
            Util.initializePersistenceManager();
            Util.createStaticEventSubscription();
            if ("true".equals(ServerConfiguration.getInstance().getFirstProperty("EnableMetering"))) {
                UsageStatsAxis2ConfigurationContextObserver statObserver = new UsageStatsAxis2ConfigurationContextObserver();
                context.getBundleContext().registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)statObserver, null);
                log.info((Object)"Observer to register the module for request statistics publishing was registered");
            }
            log.debug((Object)"******* Multitenancy Usage Agent bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Failed to activate Multitenancy Usage Agent bundle ****", e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Multitenancy Metering Usage Agent bundle is deactivated ******* ");
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        Util.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        Util.setRealmService(null);
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        Util.setConfigurationContextService(contextService);
        PublisherUtils.setConfigurationContextService(contextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        Util.setConfigurationContextService(null);
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfiguration")
    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        Util.setServerConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        Util.setServerConfiguration(null);
    }

    @Reference(name="eventbroker.service", service=EventBroker.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventBrokerService")
    protected void setEventBrokerService(EventBroker registryEventBrokerService) {
        Util.setEventBrokerService(registryEventBrokerService);
    }

    protected void unsetEventBrokerService(EventBroker registryEventBrokerService) {
        Util.setEventBrokerService(null);
    }

    @Reference(name="org.wso2.carbon.statistics.services", service=SystemStatisticsUtil.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetSystemStatisticsUtil")
    protected void setSystemStatisticsUtil(SystemStatisticsUtil systemStatisticsUtil) {
        Util.setSystemStatisticsUtil(systemStatisticsUtil);
    }

    protected void unsetSystemStatisticsUtil(SystemStatisticsUtil systemStatisticsUtil) {
        Util.setSystemStatisticsUtil(null);
    }
}

