/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.saaj.util.IDGenerator;
import org.apache.axis2.saaj.util.SAAJUtil;

public class SOAPMessageHelper {
    public static SOAPEnvelope cloneSOAPEnvelope(SOAPEnvelope envelope) {
        Iterator itr;
        SOAPEnvelope newEnvelope = "http://schemas.xmlsoap.org/soap/envelope/".equals(envelope.getBody().getNamespace().getNamespaceURI()) ? OMAbstractFactory.getSOAP11Factory().getDefaultEnvelope() : OMAbstractFactory.getSOAP12Factory().getDefaultEnvelope();
        if (envelope.getHeader() != null) {
            itr = envelope.getHeader().cloneOMElement().getChildren();
            while (itr.hasNext()) {
                newEnvelope.getHeader().addChild((OMNode)itr.next());
            }
        }
        if (envelope.getBody() != null) {
            itr = envelope.getBody().cloneOMElement().getChildren();
            while (itr.hasNext()) {
                newEnvelope.getBody().addChild((OMNode)itr.next());
            }
        }
        return newEnvelope;
    }

    public static SOAPEnvelope buildSOAPEnvelopeFromBytes(byte[] data) throws SOAPException, IOException {
        if (data != null) {
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage smsg = mf.createMessage(new MimeHeaders(), new ByteArrayInputStream(data));
            return SAAJUtil.toOMSOAPEnvelope(smsg.getSOAPPart().getDocumentElement());
        }
        return null;
    }

    public static SOAPEnvelope buildSOAPEnvelopeFromBytes(byte[] data, boolean isSoap11) throws SOAPException, IOException {
        MessageFactory mf = MessageFactory.newInstance();
        if (!isSoap11) {
            MimeHeaders mimeHeaders = new MimeHeaders();
            mimeHeaders.addHeader("Content-ID", IDGenerator.generateID());
            mimeHeaders.addHeader("content-type", "application/soap+xml");
            SOAPMessage smsg = mf.createMessage(mimeHeaders, new ByteArrayInputStream(data));
            return SAAJUtil.toOMSOAPEnvelope(smsg.getSOAPPart().getDocumentElement());
        }
        if (data != null) {
            SOAPMessage smsg = mf.createMessage(new MimeHeaders(), new ByteArrayInputStream(data));
            return SAAJUtil.toOMSOAPEnvelope(smsg.getSOAPPart().getDocumentElement());
        }
        return null;
    }
}

