/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.digest;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.caching.CachingException;
import org.wso2.caching.digest.DOMHASHGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REQUESTHASHGenerator
extends DOMHASHGenerator {
    public static final String MD5_DIGEST_ALGORITHM = "MD5";
    private static final Log log = LogFactory.getLog(REQUESTHASHGenerator.class);

    @Override
    public String getDigest(MessageContext msgContext) throws CachingException {
        SOAPBody body = msgContext.getEnvelope().getBody();
        String toAddress = null;
        if (msgContext.getTo() != null) {
            toAddress = msgContext.getTo().getAddress();
        }
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (body != null) {
            byte[] digest = null;
            digest = toAddress != null ? this.getDigest((OMNode)body, toAddress, (Map<String, String>)headers, MD5_DIGEST_ALGORITHM) : this.getDigest((OMNode)body, MD5_DIGEST_ALGORITHM);
            return digest != null ? this.getStringRepresentation(digest) : null;
        }
        return null;
    }

    public byte[] getDigest(OMNode node, String toAddress, Map<String, String> headers, String digestAlgorithm) throws CachingException {
        if (node.getType() == 1) {
            return this.getDigest((OMElement)node, toAddress, headers, digestAlgorithm);
        }
        if (node.getType() == 4) {
            return this.getDigest((OMText)node, digestAlgorithm);
        }
        if (node.getType() == 3) {
            return this.getDigest((OMProcessingInstruction)node, digestAlgorithm);
        }
        return new byte[0];
    }

    public byte[] getDigest(OMElement element, String toAddress, Map<String, String> headers, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1);
            dos.write(this.getExpandedName(element).getBytes("UnicodeBigUnmarked"));
            dos.write(0);
            dos.write(0);
            dos.write(toAddress.getBytes("UnicodeBigUnmarked"));
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                dos.write(this.getDigest(key, value, digestAlgorithm));
            }
            Collection attrs = this.getAttributesWithoutNS(element);
            dos.writeInt(attrs.size());
            Iterator<String> itr = attrs.iterator();
            while (itr.hasNext()) {
                dos.write(this.getDigest((OMAttribute)itr.next(), digestAlgorithm));
            }
            OMNode node = element.getFirstOMChild();
            int length = 0;
            itr = element.getChildElements();
            while (itr.hasNext()) {
                ++length;
                itr.next();
            }
            dos.writeInt(length);
            while (node != null) {
                dos.write(this.getDigest(node, toAddress, headers, digestAlgorithm));
                node = node.getNextOMSibling();
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (IOException e) {
            this.handleException("Error in calculating the digest value for the OMElement : " + element, e);
        }
        return digest;
    }

    public byte[] getDigest(String key, String value, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        if (!key.equalsIgnoreCase("Date") && !key.equalsIgnoreCase("User-Agent")) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)2);
                md.update(key.getBytes("UnicodeBigUnmarked"));
                if (value != null) {
                    md.update((byte)0);
                    md.update((byte)0);
                    md.update(value.getBytes("UnicodeBigUnmarked"));
                }
                digest = md.digest();
            }
            catch (NoSuchAlgorithmException e) {
                this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
            }
            catch (UnsupportedEncodingException e) {
                this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
            }
        }
        return digest;
    }

    private void handleException(String message, Throwable cause) throws CachingException {
        log.debug((Object)message, cause);
        throw new CachingException(message, cause);
    }
}

