/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching;

import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachableResponse
implements Serializable {
    private byte[] responseEnvelope;
    private boolean inUse;
    private String requestHash;
    private String responseHash;
    private long expireTimeMillis;
    private long timeout;
    private boolean isSOAP11;
    private Map<String, Object> headerProperties;

    public boolean isExpired() {
        return this.timeout <= 0L || this.expireTimeMillis < System.currentTimeMillis();
    }

    public void reincarnate(long timeout) {
        if (!this.isExpired()) {
            throw new IllegalStateException("Unexpired Cached Responses cannot be reincarnated");
        }
        this.responseEnvelope = null;
        this.headerProperties = null;
        this.responseHash = null;
        this.expireTimeMillis = System.currentTimeMillis() + timeout;
        this.setTimeout(timeout);
    }

    public byte[] getResponseEnvelope() {
        return this.responseEnvelope;
    }

    public void setResponseEnvelope(byte[] responseEnvelope) {
        this.responseEnvelope = responseEnvelope;
    }

    public String getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(String requestHash) {
        this.requestHash = requestHash;
    }

    public String getResponseHash() {
        return this.responseHash;
    }

    public void setResponseHash(String responseHash) {
        this.responseHash = responseHash;
    }

    public long getExpireTimeMillis() {
        return this.expireTimeMillis;
    }

    public void setExpireTimeMillis(long expireTimeMillis) {
        this.expireTimeMillis = expireTimeMillis;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public synchronized boolean isInUse() {
        return this.inUse;
    }

    public boolean isSOAP11() {
        return this.isSOAP11;
    }

    public void setSOAP11(boolean isSOAP11) {
        this.isSOAP11 = isSOAP11;
    }

    public Map<String, Object> getHeaderProperties() {
        return this.headerProperties;
    }

    public void setHeaderProperties(Map<String, Object> headerProperties) {
        this.headerProperties = headerProperties;
    }
}

