/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12Factory;
import org.apache.axis2.saaj.NodeImplEx;
import org.apache.axis2.saaj.NodeListImpl;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPMessageImpl;
import org.apache.axis2.saaj.TextImplEx;
import org.apache.axis2.saaj.util.IDGenerator;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class SOAPPartImpl
extends SOAPPart {
    private static final Log log = LogFactory.getLog(SOAPPartImpl.class);
    private Document document;
    private SOAPMessage soapMessage;
    private SOAPEnvelopeImpl envelope;
    private final MimeHeaders mimeHeaders;

    public SOAPPartImpl(SOAPMessageImpl parentSoapMsg, SOAPEnvelopeImpl soapEnvelope) {
        this.mimeHeaders = parentSoapMsg.getMimeHeaders();
        this.soapMessage = parentSoapMsg;
        this.envelope = soapEnvelope;
        this.document = soapEnvelope.getOwnerDocument();
        this.envelope.setSOAPPartParent(this);
    }

    public SOAPPartImpl(SOAPMessageImpl parentSoapMsg, InputStream inputStream, MimeHeaders mimeHeaders, Attachments attachments) throws SOAPException {
        XMLStreamReader streamReader;
        String soapEnvelopeNamespaceURI;
        SOAP11Factory soapFactory;
        boolean isMTOM;
        String charset;
        ContentType contentType = null;
        if (mimeHeaders == null) {
            this.mimeHeaders = new MimeHeaders();
            this.mimeHeaders.addHeader("Content-ID", IDGenerator.generateID());
            this.mimeHeaders.addHeader("content-type", "application/soap+xml");
        } else {
            String[] contentTypes = mimeHeaders.getHeader("Content-Type");
            if (contentTypes != null && contentTypes.length > 0) {
                try {
                    contentType = new ContentType(contentTypes[0]);
                }
                catch (ParseException ex) {
                    throw new SOAPException("Invalid content type '" + contentTypes[0] + "'");
                }
            }
            this.mimeHeaders = SAAJUtil.copyMimeHeaders(mimeHeaders);
        }
        this.soapMessage = parentSoapMsg;
        if (contentType == null) {
            charset = null;
            isMTOM = false;
            soapFactory = new SOAP11Factory();
            soapEnvelopeNamespaceURI = null;
        } else {
            String soapContentType;
            String baseType = contentType.getBaseType().toLowerCase();
            if (baseType.equals("application/xop+xml")) {
                isMTOM = true;
                String typeParam = contentType.getParameter("type");
                if (typeParam == null) {
                    throw new SOAPException("Missing 'type' parameter in XOP content type");
                }
                soapContentType = typeParam.toLowerCase();
            } else {
                isMTOM = false;
                soapContentType = baseType;
            }
            if (soapContentType.equals("text/xml")) {
                soapEnvelopeNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
                soapFactory = new SOAP11Factory();
            } else if (soapContentType.equals("application/soap+xml")) {
                soapEnvelopeNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
                soapFactory = new SOAP12Factory();
            } else {
                throw new SOAPException("Unrecognized content type '" + soapContentType + "'");
            }
            charset = contentType.getParameter("charset");
        }
        try {
            streamReader = charset != null ? StAXUtils.createXMLStreamReader((InputStream)inputStream, charset) : StAXUtils.createXMLStreamReader((InputStream)inputStream);
        }
        catch (XMLStreamException e) {
            throw new SOAPException(e);
        }
        Object builder = isMTOM && attachments != null ? new MTOMStAXSOAPModelBuilder(streamReader, (SOAPFactory)soapFactory, attachments, soapEnvelopeNamespaceURI) : new StAXSOAPModelBuilder(streamReader, (SOAPFactory)soapFactory, soapEnvelopeNamespaceURI);
        try {
            SOAPEnvelope soapEnvelope = builder.getSOAPEnvelope();
            this.envelope = new SOAPEnvelopeImpl((org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl)soapEnvelope);
            this.envelope.element.build();
            this.document = this.envelope.getOwnerDocument();
            this.envelope.setSOAPPartParent(this);
        }
        catch (Exception e) {
            throw new SOAPException(e);
        }
    }

    public SOAPMessage getSoapMessage() {
        return this.soapMessage;
    }

    @Override
    public javax.xml.soap.SOAPEnvelope getEnvelope() throws SOAPException {
        return this.envelope;
    }

    @Override
    public void removeMimeHeader(String header) {
        this.mimeHeaders.removeHeader(header);
    }

    @Override
    public void removeAllMimeHeaders() {
        this.mimeHeaders.removeAllHeaders();
    }

    @Override
    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    @Override
    public void setMimeHeader(String name, String value) {
        this.mimeHeaders.setHeader(name, value);
    }

    @Override
    public void addMimeHeader(String header, String value) {
        this.mimeHeaders.addHeader(header, value);
    }

    @Override
    public Iterator getAllMimeHeaders() {
        return this.mimeHeaders.getAllHeaders();
    }

    @Override
    public Iterator getMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getMatchingHeaders(names);
    }

    @Override
    public Iterator getNonMatchingMimeHeaders(String[] names) {
        return this.mimeHeaders.getNonMatchingHeaders(names);
    }

    @Override
    public void setContent(Source source) throws SOAPException {
        try {
            XMLStreamReader reader;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (source instanceof StreamSource) {
                reader = inputFactory.createXMLStreamReader(source);
            } else {
                StreamResult result = new StreamResult(baos);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.transform(source, result);
                ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
                reader = inputFactory.createXMLStreamReader(is);
            }
            StAXSOAPModelBuilder builder1 = null;
            if (this.envelope.element.getOMFactory() instanceof SOAP11Factory) {
                builder1 = new StAXSOAPModelBuilder(reader, (SOAPFactory)((SOAP11Factory)this.envelope.element.getOMFactory()), null);
            } else if (this.envelope.element.getOMFactory() instanceof SOAP12Factory) {
                builder1 = new StAXSOAPModelBuilder(reader, (SOAPFactory)((SOAP12Factory)this.envelope.element.getOMFactory()), null);
            }
            SOAPEnvelope soapEnvelope = builder1.getSOAPEnvelope();
            this.envelope = new SOAPEnvelopeImpl((org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl)soapEnvelope);
            this.envelope.element.build();
            this.document = this.envelope.getOwnerDocument();
            this.envelope.setSOAPPartParent(this);
        }
        catch (TransformerFactoryConfigurationError e) {
            log.error((Object)e);
            throw new SOAPException(e);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new SOAPException(e);
        }
    }

    @Override
    public Source getContent() throws SOAPException {
        return new DOMSource(this.document);
    }

    @Override
    public DocumentType getDoctype() {
        return this.document.getDoctype();
    }

    @Override
    public DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    @Override
    public Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return this.document.createElement(tagName);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    @Override
    public Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    @Override
    public Comment createComment(String data) {
        return this.document.createComment(data);
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return this.document.createCDATASection(data);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return this.document.createProcessingInstruction(target, data);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return this.document.createAttribute(name);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        return this.document.createEntityReference(name);
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return this.document.getElementsByTagName(tagname);
    }

    @Override
    public org.w3c.dom.Node importNode(org.w3c.dom.Node importedNode, boolean deep) throws DOMException {
        return this.document.importNode(importedNode, deep);
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.document.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    @Override
    public String getInputEncoding() {
        return this.envelope.getEncodingStyle();
    }

    @Override
    public String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    @Override
    public boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.document.setXmlStandalone(xmlStandalone);
    }

    @Override
    public String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.document.setXmlVersion(xmlVersion);
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.document.setStrictErrorChecking(strictErrorChecking);
    }

    @Override
    public String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.document.setDocumentURI(documentURI);
    }

    @Override
    public org.w3c.dom.Node adoptNode(org.w3c.dom.Node source) throws DOMException {
        return this.document.adoptNode(source);
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    @Override
    public void normalizeDocument() {
        this.document.normalizeDocument();
    }

    @Override
    public org.w3c.dom.Node renameNode(org.w3c.dom.Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return this.document.renameNode(n, namespaceURI, qualifiedName);
    }

    @Override
    public String getNodeName() {
        return this.document.getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.document.getNodeValue();
    }

    @Override
    public void setNodeValue(String arg0) throws DOMException {
        this.document.setNodeValue(arg0);
    }

    @Override
    public short getNodeType() {
        return this.document.getNodeType();
    }

    @Override
    public org.w3c.dom.Node getParentNode() {
        return this.toSAAJNode(this.document.getParentNode());
    }

    @Override
    public NodeList getChildNodes() {
        NodeList childNodes = this.document.getChildNodes();
        NodeListImpl nodes = new NodeListImpl();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            nodes.addNode(this.toSAAJNode(childNodes.item(i)));
        }
        return nodes;
    }

    @Override
    public org.w3c.dom.Node getFirstChild() {
        return this.toSAAJNode(this.document.getFirstChild());
    }

    @Override
    public org.w3c.dom.Node getLastChild() {
        return this.toSAAJNode(this.document.getLastChild());
    }

    @Override
    public org.w3c.dom.Node getPreviousSibling() {
        return this.toSAAJNode(this.document.getPreviousSibling());
    }

    @Override
    public org.w3c.dom.Node getNextSibling() {
        return this.toSAAJNode(this.document.getNextSibling());
    }

    @Override
    public NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    @Override
    public Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    @Override
    public org.w3c.dom.Node insertBefore(org.w3c.dom.Node newChild, org.w3c.dom.Node refChild) throws DOMException {
        return this.document.insertBefore(newChild, refChild);
    }

    @Override
    public org.w3c.dom.Node replaceChild(org.w3c.dom.Node newChild, org.w3c.dom.Node oldChild) throws DOMException {
        return this.document.replaceChild(newChild, oldChild);
    }

    @Override
    public org.w3c.dom.Node removeChild(org.w3c.dom.Node oldChild) throws DOMException {
        if (oldChild instanceof SOAPElementImpl) {
            oldChild = ((SOAPElementImpl)oldChild).getElement();
        } else if (oldChild instanceof TextImplEx) {
            // empty if block
        }
        return this.document.removeChild(oldChild);
    }

    @Override
    public org.w3c.dom.Node appendChild(org.w3c.dom.Node newChild) throws DOMException {
        return this.document.appendChild(newChild);
    }

    @Override
    public boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    @Override
    public org.w3c.dom.Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    @Override
    public void normalize() {
        this.document.normalize();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        return this.document.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.document.getPrefix();
    }

    @Override
    public void setPrefix(String arg0) throws DOMException {
        this.document.setPrefix(arg0);
    }

    @Override
    public String getLocalName() {
        return this.document.getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    protected void setMessage(SOAPMessageImpl message) {
        this.soapMessage = message;
    }

    @Override
    public String getBaseURI() {
        return this.document.getBaseURI();
    }

    @Override
    public short compareDocumentPosition(org.w3c.dom.Node node) throws DOMException {
        return this.document.compareDocumentPosition(node);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.document.getTextContent();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.document.setTextContent(textContent);
    }

    @Override
    public boolean isSameNode(org.w3c.dom.Node other) {
        return this.document.isSameNode(other);
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return this.document.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return this.document.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return this.document.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean isEqualNode(org.w3c.dom.Node node) {
        return this.document.isEqualNode(node);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.document.getFeature(feature, version);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.document.setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.document.getUserData(key);
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public void setParentElement(SOAPElement parent) throws SOAPException {
        throw new SOAPException("Cannot set the parent element of SOAPPart");
    }

    @Override
    public SOAPElement getParentElement() {
        return null;
    }

    @Override
    public void detachNode() {
    }

    @Override
    public void recycleNode() {
    }

    @Override
    public void setValue(String value) {
        throw new IllegalStateException("Cannot set value of SOAPPart.");
    }

    Node toSAAJNode(org.w3c.dom.Node domNode) {
        return NodeImplEx.toSAAJNode(domNode, this);
    }
}

