/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.ConfigurableDataHandler;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DispatchPhase;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.saaj.SOAPMessageImpl;
import org.apache.axis2.saaj.util.IDGenerator;
import org.apache.axis2.saaj.util.SAAJUtil;
import org.apache.axis2.saaj.util.UnderstandAllHeadersHandler;

public class SOAPConnectionImpl
extends SOAPConnection {
    private boolean closed = false;
    private final ConfigurationContext configurationContext;

    SOAPConnectionImpl() throws SOAPException {
        try {
            this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            this.disableMustUnderstandProcessing(this.configurationContext.getAxisConfiguration());
        }
        catch (AxisFault ex) {
            throw new SOAPException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SOAPMessage call(SOAPMessage request, Object endpoint) throws SOAPException {
        Iterator it;
        SOAPEnvelope envelope;
        OperationClient opClient;
        ServiceClient serviceClient;
        URL url;
        if (this.closed) {
            throw new SOAPException("SOAPConnection closed");
        }
        try {
            url = endpoint instanceof URL ? (URL)endpoint : new URL(endpoint.toString());
        }
        catch (MalformedURLException e) {
            throw new SOAPException(e.getMessage());
        }
        Options options = new Options();
        options.setTo(new EndpointReference(url.toString()));
        try {
            serviceClient = new ServiceClient(this.configurationContext, null);
            opClient = serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        }
        catch (AxisFault e) {
            throw new SOAPException(e);
        }
        options.setProperty("CHARACTER_SET_ENCODING", request.getProperty("javax.xml.soap.character-set-encoding"));
        opClient.setOptions(options);
        MessageContext requestMsgCtx = new MessageContext();
        if (SOAPConnectionImpl.isMTOM(request)) {
            envelope = SAAJUtil.toOMSOAPEnvelope(request);
            options.setProperty("enableMTOM", (Object)"true");
        } else {
            envelope = SAAJUtil.toOMSOAPEnvelope(request.getSOAPPart().getDocumentElement());
            if (request.countAttachments() != 0) {
                Attachments attachments = requestMsgCtx.getAttachmentMap();
                it = request.getAttachments();
                while (it.hasNext()) {
                    AttachmentPart attachment = (AttachmentPart)it.next();
                    String contentId = attachment.getContentId();
                    if (contentId == null) {
                        contentId = IDGenerator.generateID();
                    }
                    DataHandler handler = attachment.getDataHandler();
                    if (!SAAJUtil.compareContentTypes(attachment.getContentType(), handler.getContentType())) {
                        ConfigurableDataHandler configuredHandler = new ConfigurableDataHandler(handler.getDataSource());
                        configuredHandler.setContentType(attachment.getContentType());
                        handler = configuredHandler;
                    }
                    attachments.addDataHandler(contentId, handler);
                }
                options.setProperty("enableSwA", (Object)"true");
            }
        }
        HashMap<String, String> httpHeaders = null;
        it = request.getMimeHeaders().getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            String name = header.getName().toLowerCase();
            if (name.equals("soapaction")) {
                requestMsgCtx.setSoapAction(header.getValue());
                continue;
            }
            if (name.equals("content-type")) continue;
            if (httpHeaders == null) {
                httpHeaders = new HashMap<String, String>();
            }
            httpHeaders.put(header.getName(), header.getValue());
        }
        if (httpHeaders != null) {
            requestMsgCtx.setProperty("HTTP_HEADERS", httpHeaders);
        }
        try {
            MessageContext responseMsgCtx;
            try {
                requestMsgCtx.setEnvelope(envelope);
                opClient.addMessageContext(requestMsgCtx);
                opClient.execute(true);
                responseMsgCtx = opClient.getMessageContext("In");
            }
            catch (AxisFault ex) {
                throw new SOAPException(ex.getMessage(), ex);
            }
            SOAPMessage response = this.getSOAPMessage(responseMsgCtx.getEnvelope());
            Attachments attachments = responseMsgCtx.getAttachmentMap();
            for (String contentId : attachments.getAllContentIDs()) {
                if (contentId.equals(attachments.getSOAPPartContentID())) continue;
                AttachmentPart ap = response.createAttachmentPart(attachments.getDataHandler(contentId));
                ap.setContentId(contentId);
                response.addAttachmentPart(ap);
            }
            SOAPMessage sOAPMessage = response;
            return sOAPMessage;
        }
        finally {
            try {
                serviceClient.cleanupTransport();
                serviceClient.cleanup();
            }
            catch (AxisFault ex) {
                throw new SOAPException(ex);
            }
        }
    }

    private static boolean isMTOM(SOAPMessage soapMessage) {
        SOAPPart soapPart = soapMessage.getSOAPPart();
        String[] contentTypes = soapPart.getMimeHeader("Content-Type");
        if (contentTypes != null && contentTypes.length > 0) {
            return SAAJUtil.normalizeContentType(contentTypes[0]).equals("application/xop+xml");
        }
        return false;
    }

    private void disableMustUnderstandProcessing(AxisConfiguration config) {
        DispatchPhase phase = SOAPConnectionImpl.getDispatchPhase(config.getInFlowPhases());
        if (phase != null) {
            phase.addHandler((Handler)new UnderstandAllHeadersHandler());
        }
        if ((phase = SOAPConnectionImpl.getDispatchPhase(config.getInFaultFlowPhases())) != null) {
            phase.addHandler((Handler)new UnderstandAllHeadersHandler());
        }
    }

    private static DispatchPhase getDispatchPhase(List<Phase> phases) {
        for (Phase phase : phases) {
            if (!(phase instanceof DispatchPhase)) continue;
            return (DispatchPhase)phase;
        }
        return null;
    }

    @Override
    public void close() throws SOAPException {
        if (this.closed) {
            throw new SOAPException("SOAPConnection Closed");
        }
        try {
            this.configurationContext.terminate();
        }
        catch (AxisFault axisFault) {
            throw new SOAPException(axisFault.getMessage());
        }
        this.closed = true;
    }

    private SOAPMessage getSOAPMessage(SOAPEnvelope respOMSoapEnv) throws SOAPException {
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage response = mf.createMessage();
        SOAPPart sPart = response.getSOAPPart();
        javax.xml.soap.SOAPEnvelope env = sPart.getEnvelope();
        SOAPBody body = env.getBody();
        javax.xml.soap.SOAPHeader header = env.getHeader();
        SOAPHeader header2 = respOMSoapEnv.getHeader();
        if (header2 != null) {
            Iterator hbIter = header2.examineAllHeaderBlocks();
            while (hbIter.hasNext()) {
                SOAPHeaderBlock hb = (SOAPHeaderBlock)hbIter.next();
                QName hbQName = hb.getQName();
                SOAPHeaderElement headerEle = header.addHeaderElement(env.createName(hbQName.getLocalPart(), hbQName.getPrefix(), hbQName.getNamespaceURI()));
                Iterator attribIter = hb.getAllAttributes();
                while (attribIter.hasNext()) {
                    OMAttribute attr = (OMAttribute)attribIter.next();
                    QName attrQName = attr.getQName();
                    headerEle.addAttribute(env.createName(attrQName.getLocalPart(), attrQName.getPrefix(), attrQName.getNamespaceURI()), attr.getAttributeValue());
                }
                String role = hb.getRole();
                if (role != null) {
                    headerEle.setActor(role);
                }
                headerEle.setMustUnderstand(hb.getMustUnderstand());
                this.toSAAJElement(headerEle, (OMNode)hb, response);
            }
        }
        this.toSAAJElement(body, (OMNode)respOMSoapEnv.getBody(), response);
        return response;
    }

    private void toSAAJElement(SOAPElement saajEle, OMNode omNode, SOAPMessage saajSOAPMsg) throws SOAPException {
        if (omNode instanceof OMText) {
            return;
        }
        if (omNode instanceof OMElement) {
            OMElement omEle = (OMElement)omNode;
            Iterator childIter = omEle.getChildren();
            while (childIter.hasNext()) {
                OMNode omChildNode = (OMNode)childIter.next();
                SOAPElement saajChildEle = null;
                if (omChildNode instanceof OMText) {
                    OMText omText = (OMText)omChildNode;
                    if (omText.isOptimized()) {
                        DataHandler datahandler = (DataHandler)omText.getDataHandler();
                        AttachmentPart attachment = saajSOAPMsg.createAttachmentPart(datahandler);
                        String id = IDGenerator.generateID();
                        attachment.setContentId("<" + id + ">");
                        attachment.setContentType(datahandler.getContentType());
                        saajSOAPMsg.addAttachmentPart(attachment);
                        SOAPElement xopInclude = saajEle.addChildElement("Include", "xop", "http://www.w3.org/2004/08/xop/include");
                        xopInclude.addAttribute(saajSOAPMsg.getSOAPPart().getEnvelope().createName("href"), "cid:" + id);
                    } else {
                        saajChildEle = saajEle.addTextNode(omText.getText());
                    }
                } else if (omChildNode instanceof OMElement) {
                    OMElement omChildEle = (OMElement)omChildNode;
                    QName omChildQName = omChildEle.getQName();
                    saajChildEle = saajEle.addChildElement(omChildQName.getLocalPart(), omChildQName.getPrefix(), omChildQName.getNamespaceURI());
                    Iterator attribIter = omChildEle.getAllAttributes();
                    while (attribIter.hasNext()) {
                        OMAttribute attr = (OMAttribute)attribIter.next();
                        QName attrQName = attr.getQName();
                        saajChildEle.addAttribute(saajSOAPMsg.getSOAPPart().getEnvelope().createName(attrQName.getLocalPart(), attrQName.getPrefix(), attrQName.getNamespaceURI()), attr.getAttributeValue());
                    }
                }
                this.toSAAJElement(saajChildEle, omChildNode, saajSOAPMsg);
            }
        }
    }

    @Override
    public SOAPMessage get(Object to) throws SOAPException {
        int responseCode;
        URL url = null;
        try {
            url = to instanceof URL ? (URL)to : new URL(to.toString());
        }
        catch (MalformedURLException e) {
            throw new SOAPException(e);
        }
        boolean isFailure = false;
        HttpURLConnection httpCon = null;
        try {
            httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setDoOutput(true);
            httpCon.setDoInput(true);
            httpCon.setUseCaches(false);
            httpCon.setRequestMethod("GET");
            HttpURLConnection.setFollowRedirects(true);
            httpCon.connect();
            responseCode = httpCon.getResponseCode();
            if (responseCode == 500) {
                isFailure = true;
            } else if (responseCode / 100 != 2) {
                throw new SOAPException("Error response: (" + responseCode + httpCon.getResponseMessage());
            }
        }
        catch (IOException e) {
            throw new SOAPException(e);
        }
        SOAPMessageImpl soapMessage = null;
        if (responseCode == 200) {
            try {
                MimeHeaders mimeHeaders = new MimeHeaders();
                int i = 1;
                while (true) {
                    String key = httpCon.getHeaderFieldKey(i);
                    String value = httpCon.getHeaderField(i);
                    if (key == null && value == null) break;
                    if (key != null) {
                        StringTokenizer values = new StringTokenizer(value, ",");
                        while (values.hasMoreTokens()) {
                            mimeHeaders.addHeader(key, values.nextToken().trim());
                        }
                    }
                    ++i;
                }
                InputStream httpInputStream = isFailure ? httpCon.getErrorStream() : httpCon.getInputStream();
                soapMessage = new SOAPMessageImpl(httpInputStream, mimeHeaders, false);
                httpInputStream.close();
                httpCon.disconnect();
            }
            catch (SOAPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SOAPException(e.getMessage());
            }
        }
        return soapMessage;
    }
}

