/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axiom.soap.impl.dom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.dom.soap12.SOAP12Factory;
import org.apache.axis2.saaj.SOAPEnvelopeImpl;
import org.apache.axis2.saaj.SOAPMessageImpl;

public class MessageFactoryImpl
extends MessageFactory {
    protected String soapVersion = "SOAP 1.1 Protocol";
    private boolean processMTOM;

    @Override
    public SOAPMessage createMessage() throws SOAPException {
        SOAPEnvelopeImpl soapEnvelope;
        if (this.soapVersion.equals("SOAP 1.2 Protocol")) {
            soapEnvelope = new SOAPEnvelopeImpl((org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl)new SOAP12Factory().getDefaultEnvelope());
        } else {
            if (this.soapVersion.equals("Dynamic Protocol")) {
                throw new UnsupportedOperationException("createMessage() is not supported for DYNAMIC_SOAP_PROTOCOL");
            }
            soapEnvelope = new SOAPEnvelopeImpl((org.apache.axiom.soap.impl.dom.SOAPEnvelopeImpl)new SOAP11Factory().getDefaultEnvelope());
        }
        SOAPMessageImpl soapMessage = new SOAPMessageImpl(soapEnvelope);
        soapMessage.setSaveRequired();
        return soapMessage;
    }

    @Override
    public SOAPMessage createMessage(MimeHeaders mimeheaders, InputStream inputstream) throws IOException, SOAPException {
        SOAPMessageImpl soapMessage = new SOAPMessageImpl(inputstream, mimeheaders, this.processMTOM);
        soapMessage.setSaveRequired();
        return soapMessage;
    }

    public void setSOAPVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public void setProcessMTOM(boolean processMTOM) {
        this.processMTOM = processMTOM;
    }
}

