/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.basicauth.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.authentication.framework.ApplicationAuthenticator;
import org.wso2.carbon.identity.application.authenticator.basicauth.BasicAuthenticator;
import org.wso2.carbon.identity.application.authenticator.basicauth.internal.BasicAuthenticatorDataHolder;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.governance.IdentityGovernanceService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.application.authenticator.basicauth.component", immediate=true)
public class BasicAuthenticatorServiceComponent {
    private static final Log log = LogFactory.getLog(BasicAuthenticatorServiceComponent.class);
    private static RealmService realmService;

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        log.debug((Object)"Setting the Realm Service");
        BasicAuthenticatorServiceComponent.realmService = realmService;
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        this.buildReCaptchaFilterProperties();
        try {
            BasicAuthenticator basicAuth = new BasicAuthenticator();
            ctxt.getBundleContext().registerService(ApplicationAuthenticator.class.getName(), (Object)basicAuth, null);
            if (log.isDebugEnabled()) {
                log.info((Object)"BasicAuthenticator bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"SAMLSSO Authenticator bundle activation Failed", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"BasicAuthenticator bundle is deactivated");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        log.debug((Object)"UnSetting the Realm Service");
        BasicAuthenticatorServiceComponent.realmService = null;
    }

    @Reference(name="IdentityGovernanceService", service=IdentityGovernanceService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityGovernanceService")
    protected void setIdentityGovernanceService(IdentityGovernanceService identityGovernanceService) {
        BasicAuthenticatorDataHolder.getInstance().setIdentityGovernanceService(identityGovernanceService);
    }

    protected void unsetIdentityGovernanceService(IdentityGovernanceService identityGovernanceService) {
        BasicAuthenticatorDataHolder.getInstance().setIdentityGovernanceService(null);
    }

    private void buildReCaptchaFilterProperties() {
        Path path = Paths.get(IdentityUtil.getIdentityConfigDirPath(), "captcha-config.properties");
        if (Files.exists(path, new LinkOption[0])) {
            Properties properties = new Properties();
            try (InputStreamReader in = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8);){
                properties.load(in);
            }
            catch (IOException e) {
                log.error((Object)"Error while loading 'captcha-config.properties' configuration file", (Throwable)e);
            }
            boolean reCaptchaEnabled = Boolean.valueOf(properties.getProperty("recaptcha.enabled"));
            if (reCaptchaEnabled) {
                BasicAuthenticatorDataHolder.getInstance().setRecaptchaConfigs(properties);
            }
        }
    }
}

