/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.application.authenticator.basicauth;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.core.util.SignatureUtil;
import org.wso2.carbon.identity.application.authentication.framework.AbstractApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorFlowStatus;
import org.wso2.carbon.identity.application.authentication.framework.LocalApplicationAuthenticator;
import org.wso2.carbon.identity.application.authentication.framework.config.ConfigurationFacade;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.AuthenticationFailedException;
import org.wso2.carbon.identity.application.authentication.framework.exception.InvalidCredentialsException;
import org.wso2.carbon.identity.application.authentication.framework.exception.LogoutFailedException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.authenticator.basicauth.internal.BasicAuthenticatorDataHolder;
import org.wso2.carbon.identity.application.authenticator.basicauth.internal.BasicAuthenticatorServiceComponent;
import org.wso2.carbon.identity.application.authenticator.basicauth.util.BasicAuthErrorConstants;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.captcha.connector.recaptcha.SSOLoginReCaptchaConfig;
import org.wso2.carbon.identity.core.model.IdentityErrorMsgContext;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.governance.IdentityGovernanceException;
import org.wso2.carbon.identity.recovery.RecoveryScenarios;
import org.wso2.carbon.identity.recovery.util.Utils;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class BasicAuthenticator
extends AbstractApplicationAuthenticator
implements LocalApplicationAuthenticator {
    private static final long serialVersionUID = 1819664539416029785L;
    private static final String PASSWORD_PROPERTY = "PASSWORD_PROPERTY";
    private static final String PASSWORD_RESET_ENDPOINT = "accountrecoveryendpoint/confirmrecovery.do?";
    private static final Log log = LogFactory.getLog(BasicAuthenticator.class);
    private static final String RECOVERY_ADMIN_PASSWORD_RESET_AUTO_LOGIN = "Recovery.AutoLogin.Enable";
    private static final String RESEND_CONFIRMATION_RECAPTCHA_ENABLE = "SelfRegistration.ResendConfirmationReCaptcha";
    private static final String USERNAME = "username";
    private static final String SIGNATURE = "signature";
    private static final String COOKIE_NAME = "ALOR";
    private static String RE_CAPTCHA_USER_DOMAIN = "user-domain-recaptcha";
    private List<String> omittingErrorParams = null;
    private static String USER_EXIST_THREAD_LOCAL_PROPERTY = "userExistThreadLocalProperty";

    public boolean canHandle(HttpServletRequest request) {
        String userName = request.getParameter(USERNAME);
        String password = request.getParameter("password");
        Cookie autoLoginCookie = this.getAutoLoginCookie(request.getCookies());
        return userName != null && password != null || autoLoginCookie != null;
    }

    public AuthenticatorFlowStatus process(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException, LogoutFailedException {
        Cookie autoLoginCookie = this.getAutoLoginCookie(request.getCookies());
        if (context.isLogoutRequest()) {
            return AuthenticatorFlowStatus.SUCCESS_COMPLETED;
        }
        if (autoLoginCookie != null && this.isEnableAutoLoginAfterPasswordReset(context)) {
            try {
                return this.executeAutoLoginFlow(request, response, context, autoLoginCookie);
            }
            catch (AuthenticationFailedException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error occurred while executing the Auto Login from Cookie flow: " + (Object)((Object)e)));
                }
                this.removeAutoLoginCookie(response, autoLoginCookie);
            }
        }
        return super.process(request, response, context);
    }

    protected AuthenticatorFlowStatus executeAutoLoginFlow(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context, Cookie autoLoginCookie) throws AuthenticationFailedException {
        JSONObject cookieValueJSON = this.transformCookieValueToJSON(autoLoginCookie);
        String usernameInCookie = (String)cookieValueJSON.get((Object)USERNAME);
        String usernameInHttpRequest = request.getParameter(USERNAME);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Started executing Auto Login from Cookie flow.");
        }
        if (StringUtils.isNotEmpty((String)usernameInHttpRequest) && StringUtils.isNotEmpty((String)usernameInCookie) && !StringUtils.equalsIgnoreCase((String)usernameInHttpRequest, (String)usernameInCookie)) {
            throw new AuthenticationFailedException("Username in HTTP Request: " + usernameInHttpRequest + " and username in Cookie: " + usernameInCookie + " does not match.");
        }
        this.validateCookieSignature(usernameInCookie, cookieValueJSON);
        usernameInCookie = FrameworkUtils.prependUserStoreDomainToName((String)usernameInCookie);
        String tenantDomain = MultitenantUtils.getTenantDomain((String)usernameInCookie);
        UserStoreManager userStoreManager = this.getUserStoreManager(usernameInCookie);
        usernameInCookie = this.getMultiAttributeUsername(usernameInCookie, tenantDomain, userStoreManager);
        context.setSubject(AuthenticatedUser.createLocalAuthenticatedUserFromSubjectIdentifier((String)usernameInCookie));
        this.removeAutoLoginCookie(response, autoLoginCookie);
        return AuthenticatorFlowStatus.SUCCESS_COMPLETED;
    }

    protected void initiateAuthenticationRequest(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException {
        Map parameterMap = this.getAuthenticatorConfig().getParameterMap();
        String showAuthFailureReason = null;
        String maskUserNotExistsErrorCode = null;
        String maskAdminForcedPasswordResetErrorCode = null;
        if (parameterMap != null) {
            showAuthFailureReason = (String)parameterMap.get("showAuthFailureReason");
            if (log.isDebugEnabled()) {
                log.debug((Object)("showAuthFailureReason has been set as : " + showAuthFailureReason));
            }
            if (Boolean.parseBoolean(showAuthFailureReason)) {
                maskUserNotExistsErrorCode = (String)parameterMap.get("maskUserNotExistsErrorCode");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("maskUserNotExistsErrorCode has been set as : " + maskUserNotExistsErrorCode));
                }
                String errorParamsToOmit = (String)parameterMap.get("errorParamsToOmit");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("errorParamsToOmit has been set as : " + errorParamsToOmit));
                }
                if (StringUtils.isNotBlank((String)errorParamsToOmit)) {
                    errorParamsToOmit = errorParamsToOmit.replaceAll(" ", "");
                    this.omittingErrorParams = new ArrayList<String>(Arrays.asList(errorParamsToOmit.split(",")));
                }
            }
            maskAdminForcedPasswordResetErrorCode = (String)parameterMap.get("maskAdminForcedPasswordResetErrorCode");
            if (log.isDebugEnabled()) {
                log.debug((Object)("maskAdminForcedPasswordResetErrorCode has been set as : " + maskAdminForcedPasswordResetErrorCode));
            }
        }
        String loginPage = ConfigurationFacade.getInstance().getAuthenticationEndpointURL();
        String retryPage = ConfigurationFacade.getInstance().getAuthenticationEndpointRetryURL();
        String queryParams = context.getContextIdIncludedQueryParams();
        String password = (String)context.getProperty(PASSWORD_PROPERTY);
        context.getProperties().remove(PASSWORD_PROPERTY);
        Map runtimeParams = this.getRuntimeParams(context);
        if (runtimeParams != null) {
            String inputType = null;
            String usernameFromContext = (String)runtimeParams.get(USERNAME);
            if (usernameFromContext != null) {
                inputType = "idf";
            }
            if ("idf".equalsIgnoreCase(inputType)) {
                queryParams = queryParams + "&inputType=" + inputType;
                context.addEndpointParam(USERNAME, (Serializable)((Object)usernameFromContext));
            }
        }
        try {
            String redirectURL;
            String retryParam = "";
            if (context.isRetrying()) {
                if (context.getProperty("InvalidEmailUsername") != null && ((Boolean)context.getProperty("InvalidEmailUsername")).booleanValue()) {
                    retryParam = "&authFailure=true&authFailureMsg=emailusername.fail.message";
                    context.setProperty("InvalidEmailUsername", (Object)false);
                } else {
                    retryParam = "&authFailure=true&authFailureMsg=login.fail.message";
                }
            }
            if (context.getProperty("UserTenantDomainMismatch") != null && ((Boolean)context.getProperty("UserTenantDomainMismatch")).booleanValue()) {
                retryParam = "&authFailure=true&authFailureMsg=user.tenant.domain.mismatch.message";
                context.setProperty("UserTenantDomainMismatch", (Object)false);
            }
            IdentityErrorMsgContext errorContext = IdentityUtil.getIdentityErrorMsg();
            IdentityUtil.clearIdentityErrorMsg();
            if (errorContext != null && errorContext.getErrorCode() != null) {
                String errorCode;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Identity error message context is not null");
                }
                if ((errorCode = errorContext.getErrorCode()).equals("17005")) {
                    retryParam = "&authFailure=true&authFailureMsg=account.confirmation.pending";
                    String username = request.getParameter(USERNAME);
                    Object domain = ((Map)IdentityUtil.threadLocalProperties.get()).get(RE_CAPTCHA_USER_DOMAIN);
                    if (domain != null) {
                        username = IdentityUtil.addDomainToName((String)username, (String)domain.toString());
                    }
                    redirectURL = loginPage + "?" + queryParams + "&failedUsername=" + URLEncoder.encode(username, "UTF-8") + "&errorCode=" + errorCode + "&authenticators=" + this.getName() + ":" + "LOCAL" + retryParam;
                } else if (errorCode.equals("17006")) {
                    retryParam = "&authFailure=true&authFailureMsg=password.reset.pending";
                    if (Boolean.parseBoolean(maskAdminForcedPasswordResetErrorCode)) {
                        errorCode = "17002";
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Masking password reset pending error code: 17006 with error code: " + errorCode));
                        }
                        retryParam = "&authFailure=true&authFailureMsg=login.fail.message";
                    }
                    redirectURL = loginPage + "?" + queryParams + "&failedUsername=" + URLEncoder.encode(request.getParameter(USERNAME), "UTF-8") + "&errorCode=" + errorCode + "&authenticators=" + this.getName() + ":" + "LOCAL" + retryParam;
                } else if (errorCode.equals("17007")) {
                    String username = request.getParameter(USERNAME);
                    String tenantDoamin = MultitenantUtils.getTenantDomain((String)username);
                    String callback = loginPage + "?" + queryParams + "&authenticators=" + this.getName() + ":" + "LOCAL";
                    String reason = RecoveryScenarios.ADMIN_FORCED_PASSWORD_RESET_VIA_OTP.name();
                    redirectURL = PASSWORD_RESET_ENDPOINT + queryParams + "&username=" + URLEncoder.encode(username, "UTF-8") + "&tenantdomain=" + URLEncoder.encode(tenantDoamin, "UTF-8") + "&confirmation=" + URLEncoder.encode(password, "UTF-8") + "&callback=" + URLEncoder.encode(callback, "UTF-8") + "&reason=" + URLEncoder.encode(reason, "UTF-8");
                } else if ("true".equals(showAuthFailureReason)) {
                    if (Boolean.parseBoolean(maskUserNotExistsErrorCode) && StringUtils.contains((String)errorCode, (String)"17001")) {
                        errorCode = "17002";
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Masking user not found error code: 17001 with error code: " + errorCode));
                        }
                    }
                    String reason = null;
                    if (errorCode.contains(":")) {
                        String[] errorCodeReason = errorCode.split(":");
                        errorCode = errorCodeReason[0];
                        if (errorCodeReason.length > 1) {
                            reason = errorCodeReason[1];
                        }
                    }
                    int remainingAttempts = errorContext.getMaximumLoginAttempts() - errorContext.getFailedLoginAttempts();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("errorCode : " + errorCode));
                        log.debug((Object)("username : " + request.getParameter(USERNAME)));
                        log.debug((Object)("remainingAttempts : " + remainingAttempts));
                    }
                    if (errorCode.equals("17002")) {
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("&errorCode=", errorCode);
                        paramMap.put("&failedUsername=", URLEncoder.encode(request.getParameter(USERNAME), "UTF-8"));
                        paramMap.put("&remainingAttempts=", String.valueOf(remainingAttempts));
                        retryParam = retryParam + this.buildErrorParamString(paramMap);
                        redirectURL = loginPage + "?" + queryParams + "&authenticators=" + this.getName() + ":" + "LOCAL" + retryParam;
                    } else if (errorCode.equals("17003")) {
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("&errorCode=", errorCode);
                        paramMap.put("&failedUsername=", URLEncoder.encode(request.getParameter(USERNAME), "UTF-8"));
                        if (StringUtils.isNotBlank((String)reason)) {
                            paramMap.put("&lockedReason=", reason);
                        }
                        if (remainingAttempts == 0) {
                            paramMap.put("&remainingAttempts=", "0");
                        }
                        redirectURL = response.encodeRedirectURL(retryPage + "?" + queryParams) + this.buildErrorParamString(paramMap);
                    } else if (errorCode.equals("17008")) {
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("&errorCode=", errorCode);
                        paramMap.put("&failedUsername=", URLEncoder.encode(request.getParameter(USERNAME), "UTF-8"));
                        retryParam = "&authFailure=true&authFailureMsg=login.fail.message";
                        redirectURL = loginPage + "?" + queryParams + this.buildErrorParamString(paramMap) + "&authenticators=" + this.getName() + ":" + "LOCAL" + retryParam;
                    } else {
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("&errorCode=", errorCode);
                        paramMap.put("&failedUsername=", URLEncoder.encode(request.getParameter(USERNAME), "UTF-8"));
                        retryParam = retryParam + this.buildErrorParamString(paramMap);
                        redirectURL = loginPage + "?" + queryParams + "&authenticators=" + this.getName() + ":" + "LOCAL" + retryParam;
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unknown identity error code.");
                    }
                    redirectURL = loginPage + "?" + queryParams + "&authenticators=" + this.getName() + ":" + "LOCAL" + retryParam;
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Identity error message context is null");
                }
                redirectURL = loginPage + "?" + queryParams + "&authenticators=" + this.getName() + ":" + "LOCAL" + retryParam;
            }
            redirectURL = redirectURL + this.getCaptchaParams(context.getTenantDomain());
            response.sendRedirect(redirectURL);
        }
        catch (IOException e) {
            throw new AuthenticationFailedException(BasicAuthErrorConstants.ErrorMessages.SYSTEM_ERROR_WHILE_AUTHENTICATING.getCode(), e.getMessage(), User.getUserFromUserName((String)request.getParameter(USERNAME)), (Throwable)e);
        }
    }

    protected void processAuthenticationResponse(HttpServletRequest request, HttpServletResponse response, AuthenticationContext context) throws AuthenticationFailedException {
        boolean isAuthenticated;
        String usernameFromContext;
        Map runtimeParams;
        FrameworkUtils.validateUsername((String)request.getParameter(USERNAME), (AuthenticationContext)context);
        String username = FrameworkUtils.preprocessUsername((String)request.getParameter(USERNAME), (AuthenticationContext)context);
        String password = request.getParameter("password");
        HashMap<String, String> authProperties = context.getProperties();
        if (authProperties == null) {
            authProperties = new HashMap<String, String>();
            context.setProperties(authProperties);
        }
        if ((runtimeParams = this.getRuntimeParams(context)) != null && (usernameFromContext = (String)runtimeParams.get(USERNAME)) != null && !usernameFromContext.equals(username)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Username set for identifier first login: " + usernameFromContext + " and username submitted from login page" + username + " does not match."));
            }
            throw new InvalidCredentialsException(BasicAuthErrorConstants.ErrorMessages.CREDENTIAL_MISMATCH.getCode(), BasicAuthErrorConstants.ErrorMessages.CREDENTIAL_MISMATCH.getMessage());
        }
        authProperties.put(PASSWORD_PROPERTY, password);
        UserStoreManager userStoreManager = this.getUserStoreManager(username);
        ((Map)IdentityUtil.threadLocalProperties.get()).remove(RE_CAPTCHA_USER_DOMAIN);
        try {
            this.setUserExistThreadLocal();
            isAuthenticated = userStoreManager.authenticate(MultitenantUtils.getTenantAwareUsername((String)username), (Object)password);
            if (this.isAuthPolicyAccountExistCheck()) {
                this.checkUserExistence();
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("BasicAuthentication failed while trying to authenticate the user " + username), (Throwable)e);
            }
            throw new AuthenticationFailedException(BasicAuthErrorConstants.ErrorMessages.USER_STORE_EXCEPTION_WHILE_TRYING_TO_AUTHENTICATE.getCode(), e.getMessage(), User.getUserFromUserName((String)username), (Throwable)e);
        }
        finally {
            this.clearUserExistThreadLocal();
        }
        if (!isAuthenticated) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"User authentication failed due to invalid credentials");
            }
            if (((Map)IdentityUtil.threadLocalProperties.get()).get(RE_CAPTCHA_USER_DOMAIN) != null) {
                username = IdentityUtil.addDomainToName((String)username, (String)((Map)IdentityUtil.threadLocalProperties.get()).get(RE_CAPTCHA_USER_DOMAIN).toString());
            }
            ((Map)IdentityUtil.threadLocalProperties.get()).remove(RE_CAPTCHA_USER_DOMAIN);
            throw new InvalidCredentialsException(BasicAuthErrorConstants.ErrorMessages.INVALID_CREDENTIALS.getCode(), BasicAuthErrorConstants.ErrorMessages.INVALID_CREDENTIALS.getMessage(), User.getUserFromUserName((String)username));
        }
        String tenantDomain = MultitenantUtils.getTenantDomain((String)username);
        authProperties.put("user-tenant-domain", tenantDomain);
        username = this.getMultiAttributeUsername(FrameworkUtils.prependUserStoreDomainToName((String)username), tenantDomain, userStoreManager);
        context.setSubject(AuthenticatedUser.createLocalAuthenticatedUserFromSubjectIdentifier((String)username));
        String rememberMe = request.getParameter("chkRemember");
        if ("on".equals(rememberMe)) {
            context.setRememberMe(true);
        }
    }

    protected boolean retryAuthenticationEnabled() {
        return true;
    }

    public String getContextIdentifier(HttpServletRequest request) {
        return request.getParameter("sessionDataKey");
    }

    public String getFriendlyName() {
        return "basic";
    }

    public String getName() {
        return "BasicAuthenticator";
    }

    private String buildErrorParamString(Map<String, String> paramMap) {
        StringBuilder params = new StringBuilder();
        for (Map.Entry<String, String> entry : paramMap.entrySet()) {
            params.append(this.filterAndAddParam(entry.getKey(), entry.getValue()));
        }
        return params.toString();
    }

    private String filterAndAddParam(String key, String value) {
        String keyActual = key.replaceAll("&", "").replaceAll("=", "");
        if (CollectionUtils.isNotEmpty(this.omittingErrorParams) && this.omittingErrorParams.contains(keyActual)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("omitting param " + keyActual + " in the error response."));
            }
            return "";
        }
        return key + value;
    }

    private String getCaptchaParams(String tenantDomain) {
        SSOLoginReCaptchaConfig connector = new SSOLoginReCaptchaConfig();
        String defaultCaptchaConfigName = connector.getName() + ".enable.always";
        String captchaParams = "";
        Properties captchaConfigs = this.getCaptchaConfigs();
        if (captchaConfigs != null && !captchaConfigs.isEmpty() && Boolean.parseBoolean(captchaConfigs.getProperty("recaptcha.enabled"))) {
            try {
                Property[] connectorConfigs;
                for (Property connectorConfig : connectorConfigs = BasicAuthenticatorDataHolder.getInstance().getIdentityGovernanceService().getConfiguration(new String[]{defaultCaptchaConfigName, RESEND_CONFIRMATION_RECAPTCHA_ENABLE}, tenantDomain)) {
                    if (defaultCaptchaConfigName.equals(connectorConfig.getName())) {
                        if (Boolean.parseBoolean(connectorConfig.getValue())) {
                            captchaParams = "&reCaptcha=true";
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)"Enforcing recaptcha for SSO Login is not enabled.");
                        continue;
                    }
                    if (!RESEND_CONFIRMATION_RECAPTCHA_ENABLE.equals(connectorConfig.getName())) continue;
                    if (Boolean.parseBoolean(connectorConfig.getValue())) {
                        captchaParams = captchaParams + "&reCaptchaResend=true";
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Enforcing recaptcha for resend confirmation is not enabled.");
                }
                if (!captchaParams.isEmpty()) {
                    captchaParams = captchaParams + "&reCaptchaKey=" + captchaConfigs.getProperty("recaptcha.site.key") + "&reCaptchaAPI=" + captchaConfigs.getProperty("recaptcha.api.url");
                }
            }
            catch (IdentityGovernanceException e) {
                log.error((Object)"Error occurred while verifying the captcha configs. Proceeding the authentication request without enabling recaptcha.", (Throwable)e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Recaptcha is not enabled.");
        }
        return captchaParams;
    }

    private Properties getCaptchaConfigs() {
        Properties properties = BasicAuthenticatorDataHolder.getInstance().getRecaptchaConfigs();
        if (properties != null && !properties.isEmpty() && Boolean.valueOf(properties.getProperty("recaptcha.enabled")).booleanValue() && (StringUtils.isBlank((String)properties.getProperty("recaptcha.site.key")) || StringUtils.isBlank((String)properties.getProperty("recaptcha.api.url")) || StringUtils.isBlank((String)properties.getProperty("recaptcha.secret.key")) || StringUtils.isBlank((String)properties.getProperty("recaptcha.verify.url")))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Empty values found for the captcha properties in the file captcha-config.properties.");
            }
            properties.clear();
        }
        return properties;
    }

    private void removeAutoLoginCookie(HttpServletResponse response, Cookie autoLoginCookie) {
        autoLoginCookie.setMaxAge(0);
        autoLoginCookie.setValue("");
        autoLoginCookie.setPath("/");
        response.addCookie(autoLoginCookie);
    }

    private void validateCookieSignature(String username, JSONObject cookieValueJSON) throws AuthenticationFailedException {
        String signature = (String)cookieValueJSON.get((Object)SIGNATURE);
        if (StringUtils.isEmpty((String)username) || StringUtils.isEmpty((String)signature)) {
            throw new AuthenticationFailedException("Either 'username' or 'signature' attribute is missing in value of Auto Login Cookie in JSON: " + cookieValueJSON.toString());
        }
        try {
            if (!SignatureUtil.validateSignature((String)username, (byte[])Base64.getDecoder().decode(signature))) {
                throw new AuthenticationFailedException("Signature verification failed in Auto Login Cookie for user: " + username);
            }
        }
        catch (Exception e) {
            throw new AuthenticationFailedException("Error occurred while validating the signature for the Auto Login Cookie");
        }
    }

    private JSONObject transformCookieValueToJSON(Cookie autoLoginCookie) throws AuthenticationFailedException {
        JSONParser jsonParser = new JSONParser();
        String decodedCookieValue = new String(Base64.getDecoder().decode(autoLoginCookie.getValue()));
        try {
            return (JSONObject)jsonParser.parse(decodedCookieValue);
        }
        catch (ParseException e) {
            throw new AuthenticationFailedException("Error occurred while parsing the Auto Login Cookie JSON string to a JSON object", (Throwable)e);
        }
    }

    private boolean isEnableAutoLoginAfterPasswordReset(AuthenticationContext context) throws AuthenticationFailedException {
        try {
            return Boolean.parseBoolean(Utils.getConnectorConfig((String)RECOVERY_ADMIN_PASSWORD_RESET_AUTO_LOGIN, (String)context.getTenantDomain()));
        }
        catch (IdentityEventException e) {
            throw new AuthenticationFailedException("Error occurred while resolving isEnableAutoLogin property.", (Throwable)e);
        }
    }

    private String getMultiAttributeUsername(String username, String tenantDomain, UserStoreManager userStoreManager) {
        block8: {
            String userNameUri;
            if (this.getAuthenticatorConfig().getParameterMap() != null && StringUtils.isNotBlank((String)(userNameUri = (String)this.getAuthenticatorConfig().getParameterMap().get("UserNameAttributeClaimUri")))) {
                String domain = UserCoreUtil.getDomainFromThreadLocal();
                boolean multipleAttributeEnable = StringUtils.isNotBlank((String)domain) ? Boolean.parseBoolean(userStoreManager.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("MultipleAttributeEnable")) : Boolean.parseBoolean(userStoreManager.getRealmConfiguration().getUserStoreProperty("MultipleAttributeEnable"));
                if (multipleAttributeEnable) {
                    try {
                        String usernameValue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Searching for UserNameAttribute value for user " + username + " for claim uri : " + userNameUri));
                        }
                        if (!StringUtils.isNotBlank((String)(usernameValue = userStoreManager.getUserClaimValue(MultitenantUtils.getTenantAwareUsername((String)username), userNameUri, null)))) break block8;
                        usernameValue = FrameworkUtils.prependUserStoreDomainToName((String)usernameValue);
                        username = usernameValue + "@" + tenantDomain;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("UserNameAttribute is found for user. Value is :  " + username));
                        }
                        break block8;
                    }
                    catch (UserStoreException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Error while retrieving UserNameAttribute for user : " + username), (Throwable)e);
                        }
                        break block8;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("MultipleAttribute is not enabled for user store domain : " + domain + " Therefore UserNameAttribute is not retrieved"));
                }
            }
        }
        return username;
    }

    private UserStoreManager getUserStoreManager(String username) throws AuthenticationFailedException {
        try {
            int tenantId = IdentityTenantUtil.getTenantIdOfUser((String)username);
            UserRealm userRealm = BasicAuthenticatorServiceComponent.getRealmService().getTenantUserRealm(tenantId);
            if (userRealm != null) {
                return (UserStoreManager)userRealm.getUserStoreManager();
            }
            throw new AuthenticationFailedException("Cannot find the user realm for the given tenant: " + tenantId, User.getUserFromUserName((String)username));
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can't find the UserStoreManager the user " + username), (Throwable)e);
            }
            throw new AuthenticationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    private Cookie getAutoLoginCookie(Cookie[] cookiesInRequest) {
        Optional<Object> targetCookie = Optional.empty();
        if (ArrayUtils.isNotEmpty((Object[])cookiesInRequest)) {
            targetCookie = Arrays.stream(cookiesInRequest).filter(cookie -> StringUtils.equalsIgnoreCase((String)COOKIE_NAME, (String)cookie.getName())).filter(cookie -> StringUtils.isNotEmpty((String)cookie.getValue())).findFirst();
        }
        return targetCookie.orElse(null);
    }

    private boolean isAuthPolicyAccountExistCheck() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"AuthenticationPolicy.CheckAccountExist"));
    }

    private void checkUserExistence() {
        if (!this.isUserExist().booleanValue()) {
            IdentityErrorMsgContext customErrorMessageContext = new IdentityErrorMsgContext("17001");
            IdentityUtil.setIdentityErrorMsg((IdentityErrorMsgContext)customErrorMessageContext);
        }
    }

    private Boolean isUserExist() {
        return ((Map)IdentityUtil.threadLocalProperties.get()).get(USER_EXIST_THREAD_LOCAL_PROPERTY) != null && (Boolean)((Map)IdentityUtil.threadLocalProperties.get()).get(USER_EXIST_THREAD_LOCAL_PROPERTY) != false;
    }

    private void setUserExistThreadLocal() {
        ((Map)IdentityUtil.threadLocalProperties.get()).put(USER_EXIST_THREAD_LOCAL_PROPERTY, false);
        if (log.isDebugEnabled()) {
            log.debug((Object)(USER_EXIST_THREAD_LOCAL_PROPERTY + " is added as false to thread local."));
        }
    }

    private void clearUserExistThreadLocal() {
        ((Map)IdentityUtil.threadLocalProperties.get()).remove(USER_EXIST_THREAD_LOCAL_PROPERTY);
    }
}

