/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageLoadContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateClientStorageLoadContext<InboundMessageType, OutboundMessageType>
extends AbstractProfileAction<InboundMessageType, OutboundMessageType> {
    @Nonnull
    @NotEmpty
    public static final String LOAD_NOT_NEEDED = "NoLoadNeeded";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateClientStorageLoadContext.class);
    @Nonnull
    @NonnullElements
    private Collection<ClientStorageService> storageServices = Collections.emptyList();

    public void setStorageServices(@Nonnull @NonnullElements Collection<ClientStorageService> services) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        Constraint.isNotNull(services, "StorageService collection cannot be null");
        this.storageServices = new ArrayList<ClientStorageService>(Collections2.filter(services, (Predicate)Predicates.notNull()));
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            ActionSupport.buildEvent(profileRequestContext, LOAD_NOT_NEEDED);
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, LOAD_NOT_NEEDED);
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        ClientStorageLoadContext loadCtx = new ClientStorageLoadContext();
        ArrayList<String> ids = new ArrayList<String>();
        for (ClientStorageService service : this.storageServices) {
            if (service.isLoaded()) continue;
            loadCtx.getStorageKeys().add(service.getStorageName());
            ids.add(service.getId());
        }
        if (loadCtx.getStorageKeys().isEmpty()) {
            this.log.debug("{} No ClientStorageServices require loading, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, LOAD_NOT_NEEDED);
        } else {
            this.log.debug("{} ClientStorageServices requiring load: {}", (Object)this.getLogPrefix(), ids);
            profileRequestContext.addSubcontext(loadCtx, true);
        }
    }
}

