/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.opensaml.storage.MutableStorageRecord;

@Entity
@Table(name="StorageRecords")
@NamedQueries(value={@NamedQuery(name="JPAStorageRecord.findAll", query="SELECT r FROM JPAStorageRecord r"), @NamedQuery(name="JPAStorageRecord.findAllContexts", query="SELECT distinct r.context FROM JPAStorageRecord r"), @NamedQuery(name="JPAStorageRecord.findByContext", query="SELECT r FROM JPAStorageRecord r WHERE r.context = :context"), @NamedQuery(name="JPAStorageRecord.updateExpirationByContext", query="UPDATE JPAStorageRecord r SET r.expiration = :exp WHERE r.context = :context AND r.expiration >= :now"), @NamedQuery(name="JPAStorageRecord.deleteByContext", query="DELETE FROM JPAStorageRecord r WHERE r.context = :context"), @NamedQuery(name="JPAStorageRecord.deleteByContextAndExpiration", query="DELETE FROM JPAStorageRecord r WHERE r.context = :context AND r.expiration <= :exp"), @NamedQuery(name="JPAStorageRecord.deleteByExpiration", query="DELETE FROM JPAStorageRecord r WHERE r.expiration <= :exp")})
@IdClass(value=RecordId.class)
public class JPAStorageRecord
extends MutableStorageRecord {
    public static final int CONTEXT_SIZE = 255;
    public static final int KEY_SIZE = 255;
    private String context;
    private String key;

    public JPAStorageRecord() {
        super(null, null);
    }

    @Id
    @Nonnull
    public String getContext() {
        return this.context;
    }

    public void setContext(@Nonnull @NotEmpty String ctx) {
        this.context = ctx;
    }

    @Id
    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull @NotEmpty String k) {
        this.key = k;
    }

    @Override
    @Lob
    @Column(name="value", nullable=false)
    @Nonnull
    public String getValue() {
        return super.getValue();
    }

    @Override
    @Column(name="expires", nullable=true)
    @Nullable
    public Long getExpiration() {
        return super.getExpiration();
    }

    @Override
    @Column(name="version", nullable=false)
    public long getVersion() {
        return super.getVersion();
    }

    public void resetVersion() {
        super.setVersion(1L);
    }

    public String toString() {
        return String.format("%s@%d::context=%s, key=%s, value=%s, expiration=%s, version=%s", this.getClass().getName(), this.hashCode(), this.context, this.key, this.getValue(), this.getExpiration(), this.getVersion());
    }

    @Embeddable
    public static class RecordId
    implements Serializable {
        private static final long serialVersionUID = -9149627192851655684L;
        private String context;
        private String key;

        public RecordId() {
        }

        public RecordId(@Nonnull @NotEmpty String ctx, @Nonnull @NotEmpty String k) {
            this.context = ctx;
            this.key = k;
        }

        @Column(name="context", length=255, nullable=false)
        @Nonnull
        public String getContext() {
            return this.context;
        }

        public void setContext(@Nonnull @NotEmpty String ctx) {
            this.context = ctx;
        }

        @Column(name="id", length=255, nullable=false)
        @Nonnull
        public String getKey() {
            return this.key;
        }

        public void setKey(@Nonnull @NotEmpty String k) {
            this.key = k;
        }

        public int hashCode() {
            return Objects.hash(this.context, this.key);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof RecordId) {
                RecordId id = (RecordId)o;
                return this.context.equals(id.context) && this.key.equals(id.key);
            }
            return false;
        }

        public String toString() {
            return String.format("%s:%s", this.context, this.key);
        }
    }
}

