/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.collection.LazyList;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.soap.soap11.ActorBearing;
import org.opensaml.soap.soap11.MustUnderstandBearing;
import org.opensaml.soap.soap12.RelayBearing;
import org.opensaml.soap.soap12.RoleBearing;
import org.opensaml.soap.wssecurity.EncryptedHeader;
import org.opensaml.soap.wssecurity.IdBearing;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObject;
import org.opensaml.xmlsec.encryption.EncryptedData;

public class EncryptedHeaderImpl
extends AbstractWSSecurityObject
implements EncryptedHeader {
    private EncryptedData encryptedData;
    private String wsuId;
    private XSBooleanValue soap11MustUnderstand;
    private String soap11Actor;
    private XSBooleanValue soap12MustUnderstand;
    private String soap12Role;
    private XSBooleanValue soap12Relay;

    public EncryptedHeaderImpl(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public EncryptedData getEncryptedData() {
        return this.encryptedData;
    }

    @Override
    public void setEncryptedData(EncryptedData newEncryptedData) {
        this.encryptedData = this.prepareForAssignment(this.encryptedData, newEncryptedData);
    }

    @Override
    public String getWSUId() {
        return this.wsuId;
    }

    @Override
    public void setWSUId(String newId) {
        String oldId = this.wsuId;
        this.wsuId = this.prepareForAssignment(this.wsuId, newId);
        this.registerOwnID(oldId, this.wsuId);
        this.manageQualifiedAttributeNamespace(IdBearing.WSU_ID_ATTR_NAME, this.wsuId != null);
    }

    @Override
    public Boolean isSOAP11MustUnderstand() {
        if (this.soap11MustUnderstand != null) {
            return this.soap11MustUnderstand.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    public XSBooleanValue isSOAP11MustUnderstandXSBoolean() {
        return this.soap11MustUnderstand;
    }

    @Override
    public void setSOAP11MustUnderstand(Boolean newMustUnderstand) {
        this.soap11MustUnderstand = newMustUnderstand != null ? this.prepareForAssignment(this.soap11MustUnderstand, new XSBooleanValue(newMustUnderstand, true)) : (XSBooleanValue)this.prepareForAssignment(this.soap11MustUnderstand, null);
        this.manageQualifiedAttributeNamespace(MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME, this.soap11MustUnderstand != null);
    }

    @Override
    public void setSOAP11MustUnderstand(XSBooleanValue newMustUnderstand) {
        this.soap11MustUnderstand = this.prepareForAssignment(this.soap11MustUnderstand, newMustUnderstand);
        this.manageQualifiedAttributeNamespace(MustUnderstandBearing.SOAP11_MUST_UNDERSTAND_ATTR_NAME, this.soap11MustUnderstand != null);
    }

    @Override
    public String getSOAP11Actor() {
        return this.soap11Actor;
    }

    @Override
    public void setSOAP11Actor(String newActor) {
        this.soap11Actor = this.prepareForAssignment(this.soap11Actor, newActor);
        this.manageQualifiedAttributeNamespace(ActorBearing.SOAP11_ACTOR_ATTR_NAME, this.soap11Actor != null);
    }

    @Override
    public Boolean isSOAP12MustUnderstand() {
        if (this.soap12MustUnderstand != null) {
            return this.soap12MustUnderstand.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    public XSBooleanValue isSOAP12MustUnderstandXSBoolean() {
        return this.soap12MustUnderstand;
    }

    @Override
    public void setSOAP12MustUnderstand(Boolean newMustUnderstand) {
        this.soap12MustUnderstand = newMustUnderstand != null ? this.prepareForAssignment(this.soap12MustUnderstand, new XSBooleanValue(newMustUnderstand, false)) : (XSBooleanValue)this.prepareForAssignment(this.soap12MustUnderstand, null);
        this.manageQualifiedAttributeNamespace(SOAP12_MUST_UNDERSTAND_ATTR_NAME, this.soap12MustUnderstand != null);
    }

    @Override
    public void setSOAP12MustUnderstand(XSBooleanValue newMustUnderstand) {
        this.soap12MustUnderstand = this.prepareForAssignment(this.soap12MustUnderstand, newMustUnderstand);
        this.manageQualifiedAttributeNamespace(SOAP12_MUST_UNDERSTAND_ATTR_NAME, this.soap12MustUnderstand != null);
    }

    @Override
    public String getSOAP12Role() {
        return this.soap12Role;
    }

    @Override
    public void setSOAP12Role(String newRole) {
        this.soap12Role = this.prepareForAssignment(this.soap12Role, newRole);
        this.manageQualifiedAttributeNamespace(RoleBearing.SOAP12_ROLE_ATTR_NAME, this.soap12Role != null);
    }

    @Override
    public Boolean isSOAP12Relay() {
        if (this.soap12Relay != null) {
            return this.soap12Relay.getValue();
        }
        return Boolean.FALSE;
    }

    @Override
    public XSBooleanValue isSOAP12RelayXSBoolean() {
        return this.soap12Relay;
    }

    @Override
    public void setSOAP12Relay(Boolean newRelay) {
        this.soap12Relay = newRelay != null ? this.prepareForAssignment(this.soap12Relay, new XSBooleanValue(newRelay, false)) : (XSBooleanValue)this.prepareForAssignment(this.soap12Relay, null);
        this.manageQualifiedAttributeNamespace(RelayBearing.SOAP12_RELAY_ATTR_NAME, this.soap12Relay != null);
    }

    @Override
    public void setSOAP12Relay(XSBooleanValue newRelay) {
        this.soap12Relay = this.prepareForAssignment(this.soap12Relay, newRelay);
        this.manageQualifiedAttributeNamespace(RelayBearing.SOAP12_RELAY_ATTR_NAME, this.soap12Relay != null);
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        LazyList<EncryptedData> children = new LazyList<EncryptedData>();
        if (this.encryptedData != null) {
            children.add(this.encryptedData);
        }
        return Collections.unmodifiableList(children);
    }
}

