/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.decoder.http.impl;

import java.util.List;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePayloadBodyHandler<MessageType extends XMLObject>
extends AbstractMessageHandler<MessageType> {
    private Logger log = LoggerFactory.getLogger(SimplePayloadBodyHandler.class);

    @Override
    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        Envelope env = messageContext.getSubcontext(SOAP11Context.class).getEnvelope();
        List<XMLObject> bodyChildren = env.getBody().getUnknownXMLObjects();
        if (bodyChildren == null || bodyChildren.isEmpty()) {
            throw new MessageHandlerException("SOAP Envelope Body contained no children");
        }
        if (bodyChildren.size() > 1) {
            this.log.warn("SOAP Envelope Body contained more than one child.  Returning the first as the message");
        }
        messageContext.setMessage(env.getBody().getUnknownXMLObjects().get(0));
    }
}

