/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.client.soap11.encoder.http.impl;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.httpclient.BaseHttpClientRequestXMLMessageEncoder;
import org.opensaml.soap.common.SOAPObjectBuilder;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequestSOAP11Encoder<MessageType extends XMLObject>
extends BaseHttpClientRequestXMLMessageEncoder<MessageType> {
    private final Logger log = LoggerFactory.getLogger(HttpClientRequestSOAP11Encoder.class);
    private SOAPObjectBuilder<Envelope> envBuilder;
    private SOAPObjectBuilder<Body> bodyBuilder;

    public HttpClientRequestSOAP11Encoder() {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        this.bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Constraint.isNotNull(this.envBuilder, "Envelope Builder cannot be null");
        Constraint.isNotNull(this.bodyBuilder, "Body Builder cannot be null");
    }

    @Nullable
    public HttpPost getHttpRequest() {
        return (HttpPost)super.getHttpRequest();
    }

    @Override
    public synchronized void setHttpRequest(HttpRequest httpRequest) {
        if (!(httpRequest instanceof HttpPost)) {
            throw new IllegalArgumentException("HttpClient SOAP message encoder only operates on HttpPost");
        }
        super.setHttpRequest(httpRequest);
    }

    @Override
    public void prepareContext() throws MessageEncodingException {
        MessageContext messageContext = this.getMessageContext();
        XMLObject message = (XMLObject)messageContext.getMessage();
        if (message == null) {
            throw new MessageEncodingException("No outbound message contained in message context");
        }
        if (message instanceof Envelope) {
            this.storeSOAPEnvelope((Envelope)message);
        } else {
            this.buildAndStoreSOAPMessage(message);
        }
    }

    @Override
    protected void doEncode() throws MessageEncodingException {
        Envelope envelope = this.getSOAPEnvelope();
        this.prepareHttpRequest();
        this.getHttpRequest().setEntity(this.createRequestEntity(envelope, Charset.forName("UTF-8")));
    }

    protected HttpEntity createRequestEntity(@Nonnull Envelope message, @Nullable Charset charset) throws MessageEncodingException {
        try {
            ByteArrayOutputStream arrayOut = new ByteArrayOutputStream();
            SerializeSupport.writeNode(XMLObjectSupport.marshall(message), arrayOut);
            return new ByteArrayEntity(arrayOut.toByteArray(), ContentType.create((String)"text/xml", (Charset)charset));
        }
        catch (MarshallingException e) {
            throw new MessageEncodingException("Unable to marshall SOAP envelope", e);
        }
    }

    protected void storeSOAPEnvelope(Envelope envelope) {
        this.getMessageContext().getSubcontext(SOAP11Context.class, true).setEnvelope(envelope);
    }

    protected Envelope getSOAPEnvelope() {
        return this.getMessageContext().getSubcontext(SOAP11Context.class, true).getEnvelope();
    }

    protected void buildAndStoreSOAPMessage(@Nonnull XMLObject payload) {
        Body body;
        Envelope envelope = this.getSOAPEnvelope();
        if (envelope == null) {
            envelope = this.envBuilder.buildObject();
            this.storeSOAPEnvelope(envelope);
        }
        if ((body = envelope.getBody()) == null) {
            body = this.bodyBuilder.buildObject();
            envelope.setBody(body);
        }
        if (!body.getUnknownXMLObjects().isEmpty()) {
            this.log.warn("Existing SOAP Envelope Body already contained children");
        }
        body.getUnknownXMLObjects().add(payload);
    }

    protected void prepareHttpRequest() throws MessageEncodingException {
        String soapAction = this.getSOAPAction();
        if (soapAction != null) {
            this.getHttpRequest().setHeader("SOAPAction", soapAction);
        } else {
            this.getHttpRequest().setHeader("SOAPAction", "");
        }
    }

    protected String getSOAPAction() {
        Envelope env = this.getSOAPEnvelope();
        Header header = env.getHeader();
        if (header == null) {
            return null;
        }
        List<XMLObject> objList = header.getUnknownXMLObjects(Action.ELEMENT_NAME);
        if (objList == null || objList.isEmpty()) {
            return null;
        }
        return ((Action)objList.get(0)).getValue();
    }

    @Override
    protected XMLObject getMessageToLog() {
        return this.getMessageContext().getSubcontext(SOAP11Context.class, true).getEnvelope();
    }
}

