/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import org.opensaml.messaging.context.MessageChannelSecurityContext;
import org.opensaml.profile.action.impl.AbstractMessageChannelSecurity;
import org.opensaml.profile.context.ProfileRequestContext;

public class HttpServletRequestMessageChannelSecurity
extends AbstractMessageChannelSecurity {
    private boolean defaultPortInsecure = true;

    public void setDefaultPortInsecure(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.defaultPortInsecure = flag;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest is required");
        }
    }

    protected void doExecute(ProfileRequestContext profileRequestContext) {
        MessageChannelSecurityContext channelContext = this.getParentContext().getSubcontext(MessageChannelSecurityContext.class, true);
        HttpServletRequest request = this.getHttpServletRequest();
        if (request.isSecure() && (!this.defaultPortInsecure || request.getLocalPort() != 443)) {
            channelContext.setConfidentialityActive(true);
            channelContext.setIntegrityActive(true);
        } else {
            channelContext.setConfidentialityActive(false);
            channelContext.setIntegrityActive(false);
        }
    }
}

