/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SchemaValidateXMLMessage<MessageType extends XMLObject>
extends AbstractMessageHandler<MessageType> {
    private Logger log = LoggerFactory.getLogger(SchemaValidateXMLMessage.class);
    private final Schema validationSchema;

    public SchemaValidateXMLMessage(@Nonnull Schema schema) {
        this.validationSchema = Constraint.isNotNull(schema, "Schema cannot be null");
    }

    @Nonnull
    public Schema getValidationSchema() {
        return this.validationSchema;
    }

    @Override
    protected boolean doPreInvoke(@Nonnull MessageContext<MessageType> messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        if (messageContext.getMessage() == null) {
            this.log.debug("{} Message context did not contain a message, unable to proceed", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Message context did not contain a message, unable to proceed.");
        }
        if (((XMLObject)messageContext.getMessage()).getDOM() == null) {
            this.log.debug("{} Message doesn't contain a DOM, unable to proceed", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Message doesn't contain a DOM, unable to proceed.");
        }
        return true;
    }

    @Override
    protected void doInvoke(@Nonnull MessageContext<MessageType> messageContext) throws MessageHandlerException {
        this.log.debug("{} Attempting to schema validate incoming message", (Object)this.getLogPrefix());
        try {
            Validator schemaValidator = this.validationSchema.newValidator();
            schemaValidator.validate(new DOMSource(((XMLObject)messageContext.getMessage()).getDOM()));
        }
        catch (SAXException e) {
            this.log.debug("{} Message {} is not schema-valid", new Object[]{this.getLogPrefix(), ((XMLObject)messageContext.getMessage()).getElementQName(), e});
            throw new MessageHandlerException("Message is not schema-valid.", e);
        }
        catch (IOException e) {
            this.log.debug("{} Unable to read message", (Object)this.getLogPrefix(), (Object)e);
            throw new MessageHandlerException("Unable to read message.", e);
        }
        this.log.debug("{} Message {} is valid", (Object)this.getLogPrefix(), (Object)((XMLObject)messageContext.getMessage()).getElementQName());
    }
}

