/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.authentication.analytics.login;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.application.authentication.framework.AuthenticatorStatus;
import org.wso2.carbon.identity.application.authentication.framework.config.model.StepConfig;
import org.wso2.carbon.identity.application.authentication.framework.context.AuthenticationContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedIdPData;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.User;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.data.publisher.application.authentication.AuthnDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.login.model.AuthenticationData;
import org.wso2.carbon.identity.event.event.Event;

public class AnalyticsLoginDataPublisherUtils {
    private static final String APPLICATION_DOMAIN = "Application";
    private static final String WORKFLOW_DOMAIN = "Workflow";
    private static final String INTERNAL_EVERYONE_ROLE = "Internal/everyone";

    public static AuthenticationData buildAuthnDataForAuthnStep(Event event) {
        Map properties = event.getEventProperties();
        HttpServletRequest request = (HttpServletRequest)properties.get("request");
        Map params = (Map)properties.get("params");
        AuthenticationContext context = (AuthenticationContext)properties.get("context");
        AuthenticatorStatus status = (AuthenticatorStatus)properties.get("authenticationStatus");
        AuthenticationData<String, String> authenticationData = new AuthenticationData<String, String>();
        AnalyticsLoginDataPublisherUtils.setIdpForAuthnStep(context, authenticationData);
        Object userObj = params.get("user");
        AnalyticsLoginDataPublisherUtils.setUserDataForAuthnStep(authenticationData, userObj);
        Object isFederatedObj = params.get("isFederated");
        AnalyticsLoginDataPublisherUtils.setIdpTypeForAuthnStep(authenticationData, isFederatedObj);
        authenticationData.setContextId(context.getContextIdentifier());
        authenticationData.setEventId(UUID.randomUUID().toString());
        authenticationData.setEventType("step");
        authenticationData.setAuthnSuccess(false);
        if (request != null) {
            authenticationData.setRemoteIp(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        } else {
            authenticationData.setRemoteIp((String)params.get("remote-ip-address"));
        }
        authenticationData.setServiceProvider(context.getServiceProviderName());
        authenticationData.setInboundProtocol(context.getRequestType());
        authenticationData.setRememberMe(context.isRememberMe());
        authenticationData.setForcedAuthn(context.isForceAuthenticate());
        authenticationData.setPassive(context.isPassiveAuthenticate());
        authenticationData.setInitialLogin(false);
        authenticationData.setAuthenticator(context.getCurrentAuthenticator());
        authenticationData.setSuccess(AuthenticatorStatus.PASS == status);
        authenticationData.setStepNo(context.getCurrentStep());
        AnalyticsLoginDataPublisherUtils.setTenantDataForIdpStep(context, status, authenticationData);
        authenticationData.addParameter("relyingParty", context.getRelyingParty());
        return authenticationData;
    }

    public static AuthenticationData buildAuthnDataForAuthnStepV110(Event event) {
        AuthenticationData authenticationData = AnalyticsLoginDataPublisherUtils.buildAuthnDataForAuthnStep(event);
        Map properties = event.getEventProperties();
        AuthenticationContext context = (AuthenticationContext)properties.get("context");
        authenticationData.setDuration(AnalyticsLoginDataPublisherUtils.replaceIfLongNotAvailable(context.getAnalyticsData("currentAuthenticatorDuration")));
        authenticationData.setErrorCode(AnalyticsLoginDataPublisherUtils.replaceIfStringNotAvailable(context.getAnalyticsData("currentAuthenticatorErrorCode")));
        authenticationData.setCustomParams(AnalyticsLoginDataPublisherUtils.getCustomParam(context));
        return authenticationData;
    }

    private static void setTenantDataForIdpStep(AuthenticationContext context, AuthenticatorStatus status, AuthenticationData authenticationData) {
        if (AuthenticatorStatus.PASS == status) {
            authenticationData.addParameter("tenantDomainNames", AuthnDataPublisherUtils.getTenantDomains((String)context.getTenantDomain(), (String)authenticationData.getTenantDomain()));
        } else if (context.getSequenceConfig() != null && context.getSequenceConfig().getApplicationConfig() != null && context.getSequenceConfig().getApplicationConfig().isSaaSApp()) {
            authenticationData.addParameter("tenantDomainNames", AuthnDataPublisherUtils.getTenantDomains((String)context.getTenantDomain(), (String)authenticationData.getTenantDomain()));
        } else {
            authenticationData.addParameter("tenantDomainNames", AuthnDataPublisherUtils.getTenantDomains((String)context.getTenantDomain(), null));
        }
    }

    private static void setIdpTypeForAuthnStep(AuthenticationData authenticationData, Object isFederatedObj) {
        if (isFederatedObj != null) {
            boolean isFederated = (Boolean)isFederatedObj;
            if (isFederated) {
                authenticationData.setIdentityProviderType("FEDERATED");
            } else {
                authenticationData.setIdentityProviderType("LOCAL");
                authenticationData.setLocalUsername(authenticationData.getUsername());
            }
        }
    }

    private static void setUserDataForAuthnStep(AuthenticationData authenticationData, Object userObj) {
        User user;
        if (userObj instanceof User) {
            user = (User)userObj;
            authenticationData.setTenantDomain(user.getTenantDomain());
            authenticationData.setUserStoreDomain(user.getUserStoreDomain());
            authenticationData.setUsername(user.getUserName());
        }
        if (userObj instanceof AuthenticatedUser && StringUtils.isEmpty((String)(user = (AuthenticatedUser)userObj).getUserName())) {
            authenticationData.setUsername(user.getAuthenticatedSubjectIdentifier());
        }
    }

    private static void setIdpForAuthnStep(AuthenticationContext context, AuthenticationData authenticationData) {
        if (context.getExternalIdP() == null) {
            authenticationData.setIdentityProvider("LOCAL");
        } else {
            authenticationData.setIdentityProvider(context.getExternalIdP().getIdPName());
        }
    }

    public static AuthenticationData buildAuthnDataForAuthentication(Event event) {
        Map properties = event.getEventProperties();
        HttpServletRequest request = (HttpServletRequest)properties.get("request");
        Map params = (Map)properties.get("params");
        AuthenticationContext context = (AuthenticationContext)properties.get("context");
        AuthenticatorStatus status = (AuthenticatorStatus)properties.get("authenticationStatus");
        AuthenticationData authenticationData = new AuthenticationData();
        Object userObj = params.get("user");
        AnalyticsLoginDataPublisherUtils.setUserDataForAuthentication(authenticationData, userObj);
        authenticationData = AnalyticsLoginDataPublisherUtils.setIdpDataAndStepForAuthentication(context, status, authenticationData);
        authenticationData.setEventType("overall");
        authenticationData.setContextId(context.getContextIdentifier());
        authenticationData.setEventId(UUID.randomUUID().toString());
        if (AuthenticatorStatus.PASS.equals((Object)status)) {
            authenticationData.setAuthnSuccess(true);
        } else if (AuthenticatorStatus.FAIL.equals((Object)status)) {
            authenticationData.setAuthnSuccess(false);
        }
        if (request != null) {
            authenticationData.setRemoteIp(IdentityUtil.getClientIpAddress((HttpServletRequest)request));
        } else {
            authenticationData.setRemoteIp((String)params.get("remote-ip-address"));
        }
        authenticationData.setServiceProvider(context.getServiceProviderName());
        authenticationData.setInboundProtocol(context.getRequestType());
        authenticationData.setRememberMe(context.isRememberMe());
        authenticationData.setForcedAuthn(context.isForceAuthenticate());
        authenticationData.setPassive(context.isPassiveAuthenticate());
        AnalyticsLoginDataPublisherUtils.setTenantDataForAuthentication(context, status, authenticationData);
        authenticationData.addParameter("relyingParty", context.getRelyingParty());
        return authenticationData;
    }

    public static AuthenticationData buildAuthnDataForAuthenticationV110(Event event) {
        AuthenticationData authenticationData = AnalyticsLoginDataPublisherUtils.buildAuthnDataForAuthentication(event);
        Map properties = event.getEventProperties();
        AuthenticationContext context = (AuthenticationContext)properties.get("context");
        authenticationData.setDuration(AnalyticsLoginDataPublisherUtils.replaceIfLongNotAvailable(context.getAnalyticsData("authenticationDuration")));
        authenticationData.setErrorCode(AnalyticsLoginDataPublisherUtils.replaceIfStringNotAvailable(context.getAnalyticsData("authenticationErrorCode")));
        authenticationData.setCustomParams(AnalyticsLoginDataPublisherUtils.getCustomParam(context));
        return authenticationData;
    }

    private static void setTenantDataForAuthentication(AuthenticationContext context, AuthenticatorStatus status, AuthenticationData authenticationData) {
        if (status == AuthenticatorStatus.PASS) {
            authenticationData.addParameter("tenantDomainNames", AuthnDataPublisherUtils.getTenantDomains((String)context.getTenantDomain(), (String)authenticationData.getTenantDomain()));
            authenticationData.addParameter("subjectIdentifier", context.getSequenceConfig().getAuthenticatedUser().getAuthenticatedSubjectIdentifier());
            authenticationData.addParameter("authenticatedIDPs", context.getSequenceConfig().getAuthenticatedIdPs());
        } else if (context.getSequenceConfig() != null && context.getSequenceConfig().getApplicationConfig() != null && context.getSequenceConfig().getApplicationConfig().isSaaSApp()) {
            authenticationData.addParameter("tenantDomainNames", AuthnDataPublisherUtils.getTenantDomains((String)context.getTenantDomain(), (String)authenticationData.getTenantDomain()));
        } else {
            authenticationData.addParameter("tenantDomainNames", AuthnDataPublisherUtils.getTenantDomains((String)context.getTenantDomain(), null));
        }
    }

    private static AuthenticationData setIdpDataAndStepForAuthentication(AuthenticationContext context, AuthenticatorStatus status, AuthenticationData authenticationData) {
        boolean isInitialLogin = false;
        if (status == AuthenticatorStatus.PASS) {
            Object hasFederatedStepObj = context.getProperty("hasFederatedStep");
            Object hasLocalStepObj = context.getProperty("hasLocalStep");
            Object isInitialLoginObj = context.getProperty("isInitialLogin");
            boolean hasPreviousLocalStep = AnalyticsLoginDataPublisherUtils.hasPreviousLocalEvent(context);
            boolean hasFederated = AnalyticsLoginDataPublisherUtils.convertToBoolean(hasFederatedStepObj);
            boolean hasLocal = AnalyticsLoginDataPublisherUtils.convertToBoolean(hasLocalStepObj);
            isInitialLogin = AnalyticsLoginDataPublisherUtils.convertToBoolean(isInitialLoginObj);
            if (!hasPreviousLocalStep && hasFederated && hasLocal) {
                authenticationData.setIdentityProviderType("FEDERATED,LOCAL");
                authenticationData.setStepNo(AnalyticsLoginDataPublisherUtils.getLocalStepNo(context));
            } else if (!hasPreviousLocalStep && hasLocal) {
                authenticationData.setIdentityProviderType("LOCAL");
                authenticationData.setStepNo(AnalyticsLoginDataPublisherUtils.getLocalStepNo(context));
            } else if (hasFederated) {
                authenticationData.setIdentityProviderType("FEDERATED");
            }
            authenticationData.setIdentityProvider(AuthnDataPublisherUtils.getSubjectStepIDP((AuthenticationContext)context));
            authenticationData.setSuccess(true);
            authenticationData = AnalyticsLoginDataPublisherUtils.fillLocalEvent(authenticationData, context);
        }
        authenticationData.setInitialLogin(isInitialLogin);
        return authenticationData;
    }

    private static void setUserDataForAuthentication(AuthenticationData authenticationData, Object userObj) {
        if (userObj instanceof AuthenticatedUser) {
            AuthenticatedUser user = (AuthenticatedUser)userObj;
            authenticationData.setUsername(user.getUserName());
            authenticationData.setTenantDomain(user.getTenantDomain());
            authenticationData.setUserStoreDomain(user.getUserStoreDomain());
        }
    }

    private static AuthenticationData fillLocalEvent(AuthenticationData authenticationData, AuthenticationContext context) {
        AuthenticatedIdPData localIDPData = null;
        Map previousAuthenticatedIDPs = context.getPreviousAuthenticatedIdPs();
        Map currentAuthenticatedIDPs = context.getCurrentAuthenticatedIdPs();
        if (currentAuthenticatedIDPs != null && currentAuthenticatedIDPs.size() > 0) {
            localIDPData = (AuthenticatedIdPData)currentAuthenticatedIDPs.get("LOCAL");
        }
        if (localIDPData == null && previousAuthenticatedIDPs != null && previousAuthenticatedIDPs.size() > 0) {
            localIDPData = (AuthenticatedIdPData)previousAuthenticatedIDPs.get("LOCAL");
        }
        if (localIDPData != null) {
            authenticationData.setLocalUsername(localIDPData.getUser().getAuthenticatedSubjectIdentifier());
            authenticationData.setUserStoreDomain(localIDPData.getUser().getUserStoreDomain());
            authenticationData.setTenantDomain(localIDPData.getUser().getTenantDomain());
            authenticationData.setAuthenticator(localIDPData.getAuthenticator().getName());
        }
        return authenticationData;
    }

    private static boolean hasPreviousLocalEvent(AuthenticationContext context) {
        Map previousAuthenticatedIDPs = context.getPreviousAuthenticatedIdPs();
        return previousAuthenticatedIDPs.get("LOCAL") != null;
    }

    private static boolean convertToBoolean(Object object) {
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    private static int getLocalStepNo(AuthenticationContext context) {
        int stepNo = 0;
        Map map = context.getSequenceConfig().getStepMap();
        for (Map.Entry entry : map.entrySet()) {
            StepConfig stepConfig = (StepConfig)entry.getValue();
            if (stepConfig == null || !"LOCAL".equalsIgnoreCase(stepConfig.getAuthenticatedIdP())) continue;
            stepNo = (Integer)entry.getKey();
            return stepNo;
        }
        return stepNo;
    }

    private static List<String> getCustomParam(AuthenticationContext context) {
        ArrayList<String> customParams = new ArrayList<String>();
        for (int i = 0; i < 5; ++i) {
            customParams.add(AnalyticsLoginDataPublisherUtils.replaceIfStringNotAvailable(context.getAnalyticsData("customParam" + i)));
        }
        return customParams;
    }

    public static long replaceIfLongNotAvailable(Serializable serializable) {
        if (serializable instanceof Long) {
            return (Long)serializable;
        }
        return 0L;
    }

    public static String replaceIfStringNotAvailable(Serializable serializable) {
        if (serializable instanceof String) {
            return (String)((Object)serializable);
        }
        return "NOT_AVAILABLE";
    }
}

