/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.authentication.analytics.login;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.data.publisher.application.authentication.AuthnDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.login.AnalyticsLoginDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.login.internal.AnalyticsLoginDataPublishDataHolder;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.login.model.AuthenticationData;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class AnalyticsLoginDataPublishHandlerV110
extends AbstractEventHandler {
    private static final Log LOG = LogFactory.getLog(AnalyticsLoginDataPublishHandlerV110.class);
    private static final int PAYLOAD_LENGTH = 30;

    public String getName() {
        return "analyticsLoginDataPublisherV110";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        boolean isEnabled = this.isAnalyticsLoginDataPublishingEnabled(event);
        if (!isEnabled) {
            return;
        }
        if (IdentityEventConstants.EventName.AUTHENTICATION_STEP_SUCCESS.name().equals(event.getEventName()) || IdentityEventConstants.EventName.AUTHENTICATION_STEP_FAILURE.name().equals(event.getEventName())) {
            AuthenticationData authenticationData = AnalyticsLoginDataPublisherUtils.buildAuthnDataForAuthnStepV110(event);
            this.publishAuthenticationData(authenticationData);
        } else if (IdentityEventConstants.EventName.AUTHENTICATION_SUCCESS.name().equals(event.getEventName()) || IdentityEventConstants.EventName.AUTHENTICATION_FAILURE.name().equals(event.getEventName())) {
            AuthenticationData authenticationData = AnalyticsLoginDataPublisherUtils.buildAuthnDataForAuthenticationV110(event);
            this.publishAuthenticationData(authenticationData);
        } else {
            LOG.error((Object)("Event " + event.getEventName() + " cannot be handled"));
        }
    }

    protected void publishAuthenticationData(AuthenticationData authenticationData) {
        block2: {
            try {
                Object[] payloadData = this.populatePayloadData(authenticationData);
                this.publishEvent(payloadData, authenticationData);
            }
            catch (IdentityRuntimeException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.error((Object)"Error while publishing authentication data", (Throwable)e);
            }
        }
    }

    protected Object[] populatePayloadData(AuthenticationData authenticationData) {
        int i;
        String roleList = null;
        if ("LOCAL".equalsIgnoreCase(authenticationData.getIdentityProviderType())) {
            roleList = this.getCommaSeparatedUserRoles(authenticationData.getUserStoreDomain() + "/" + authenticationData.getUsername(), authenticationData.getTenantDomain());
        } else if (StringUtils.isNotEmpty((String)authenticationData.getLocalUsername())) {
            roleList = this.getCommaSeparatedUserRoles(authenticationData.getUserStoreDomain() + "/" + authenticationData.getLocalUsername(), authenticationData.getTenantDomain());
        }
        Object[] payloadData = new Object[30];
        payloadData[0] = authenticationData.getContextId();
        payloadData[1] = authenticationData.getEventId();
        payloadData[2] = authenticationData.getEventType();
        payloadData[3] = authenticationData.isAuthnSuccess();
        payloadData[4] = AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userName", (String)authenticationData.getUsername());
        payloadData[5] = AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userName", (String)authenticationData.getLocalUsername());
        payloadData[6] = AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userStoreDomain", (String)authenticationData.getUserStoreDomain());
        payloadData[7] = authenticationData.getTenantDomain();
        payloadData[8] = authenticationData.getRemoteIp();
        payloadData[9] = "NOT_AVAILABLE";
        payloadData[10] = authenticationData.getInboundProtocol();
        payloadData[11] = AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.serviceprovider", (String)authenticationData.getServiceProvider());
        payloadData[12] = authenticationData.isRememberMe();
        payloadData[13] = authenticationData.isForcedAuthn();
        payloadData[14] = authenticationData.isPassive();
        payloadData[15] = AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.rolesCommaSeperated", (String)roleList);
        payloadData[16] = String.valueOf(authenticationData.getStepNo());
        payloadData[17] = AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.identityProvider", (String)authenticationData.getIdentityProvider());
        payloadData[18] = authenticationData.isSuccess();
        payloadData[19] = authenticationData.getAuthenticator();
        payloadData[20] = authenticationData.isInitialLogin();
        payloadData[21] = authenticationData.getIdentityProviderType();
        payloadData[22] = System.currentTimeMillis();
        payloadData[23] = AnalyticsLoginDataPublisherUtils.replaceIfLongNotAvailable(Long.valueOf(authenticationData.getDuration()));
        payloadData[24] = AnalyticsLoginDataPublisherUtils.replaceIfStringNotAvailable((Serializable)((Object)authenticationData.getErrorCode()));
        List<String> customParams = authenticationData.getCustomParams();
        for (i = 0; i < customParams.size(); ++i) {
            payloadData[25 + i] = customParams.get(i);
        }
        if (LOG.isDebugEnabled()) {
            for (i = 0; i < 30; ++i) {
                if (payloadData[i] != null) {
                    LOG.debug((Object)("Payload data for entry " + i + " " + payloadData[i].toString()));
                    continue;
                }
                LOG.debug((Object)("Payload data for entry " + i + " is null"));
            }
        }
        return payloadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishEvent(Object[] payloadData, AuthenticationData authenticationData) {
        String[] publishingDomains = (String[])authenticationData.getParameter("tenantDomainNames");
        if (publishingDomains != null && publishingDomains.length > 0) {
            try {
                FrameworkUtils.startTenantFlow((String)"carbon.super");
                for (String publishingDomain : publishingDomains) {
                    Object[] metadataArray = AuthnDataPublisherUtils.getMetaDataArray((String)publishingDomain);
                    payloadData[1] = UUID.randomUUID().toString();
                    org.wso2.carbon.databridge.commons.Event event = new org.wso2.carbon.databridge.commons.Event("org.wso2.is.analytics.stream.OverallAuthentication:1.1.0", System.currentTimeMillis(), metadataArray, null, payloadData);
                    AnalyticsLoginDataPublishDataHolder.getInstance().getPublisherService().publish(event);
                    if (!LOG.isDebugEnabled() || event == null) continue;
                    LOG.debug((Object)("Sending out to publishing domain:" + publishingDomain + " \n event : " + event.toString()));
                }
            }
            finally {
                FrameworkUtils.endTenantFlow();
            }
        }
    }

    private String getCommaSeparatedUserRoles(String userName, String tenantDomain) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving roles for user " + userName + ", tenant domain " + tenantDomain));
        }
        if (tenantDomain == null || userName == null) {
            return "";
        }
        RegistryService registryService = AnalyticsLoginDataPublishDataHolder.getInstance().getRegistryService();
        RealmService realmService = AnalyticsLoginDataPublishDataHolder.getInstance().getRealmService();
        UserRealm realm = null;
        UserStoreManager userstore = null;
        try {
            realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
            if (realm != null) {
                userstore = realm.getUserStoreManager();
                if (userstore.isExistingUser(userName)) {
                    String[] newRoles = userstore.getRoleListOfUser(userName);
                    StringBuilder sb = new StringBuilder();
                    List externalRoles = AuthnDataPublisherUtils.filterRoles((String[])newRoles);
                    for (String role : externalRoles) {
                        sb.append(",").append(role);
                    }
                    if (sb.length() > 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Returning roles, " + sb.substring(1)));
                        }
                        return sb.substring(1);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No realm found. for tenant domain : " + tenantDomain + ". Hence no roles added"));
            }
        }
        catch (CarbonException e) {
            LOG.error((Object)("Error when getting realm for " + userName + "@" + tenantDomain), (Throwable)e);
        }
        catch (UserStoreException e) {
            LOG.error((Object)("Error when getting user store for " + userName + "@" + tenantDomain), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No roles found. Returning empty string");
        }
        return "";
    }

    private boolean isAnalyticsLoginDataPublishingEnabled(Event event) throws IdentityEventException {
        if (this.configs.getModuleProperties() != null) {
            String handlerEnabled = this.configs.getModuleProperties().getProperty("analyticsLoginDataPublisherV110.enable");
            return Boolean.parseBoolean(handlerEnabled);
        }
        return false;
    }
}

