/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.data.publisher.authentication.analytics.login;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.data.publisher.application.authentication.AuthnDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.login.AnalyticsLoginDataPublisherUtils;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.login.internal.AnalyticsLoginDataPublishDataHolder;
import org.wso2.carbon.identity.data.publisher.authentication.analytics.login.model.AuthenticationData;
import org.wso2.carbon.identity.event.IdentityEventConstants;
import org.wso2.carbon.identity.event.IdentityEventException;
import org.wso2.carbon.identity.event.event.Event;
import org.wso2.carbon.identity.event.handler.AbstractEventHandler;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;

public class AnalyticsLoginDataPublishHandler
extends AbstractEventHandler {
    private static final Log LOG = LogFactory.getLog(AnalyticsLoginDataPublishHandler.class);

    public String getName() {
        return "analyticsLoginDataPublisher";
    }

    public void handleEvent(Event event) throws IdentityEventException {
        boolean isEnabled = this.isAnalyticsLoginDataPublishingEnabled(event);
        if (!isEnabled) {
            return;
        }
        if (IdentityEventConstants.EventName.AUTHENTICATION_STEP_SUCCESS.name().equals(event.getEventName()) || IdentityEventConstants.EventName.AUTHENTICATION_STEP_FAILURE.name().equals(event.getEventName())) {
            AuthenticationData authenticationData = AnalyticsLoginDataPublisherUtils.buildAuthnDataForAuthnStep(event);
            this.publishAuthenticationData(authenticationData);
        } else if (IdentityEventConstants.EventName.AUTHENTICATION_SUCCESS.name().equals(event.getEventName()) || IdentityEventConstants.EventName.AUTHENTICATION_FAILURE.name().equals(event.getEventName())) {
            AuthenticationData authenticationData = AnalyticsLoginDataPublisherUtils.buildAuthnDataForAuthentication(event);
            this.publishAuthenticationData(authenticationData);
        } else {
            LOG.error((Object)("Event " + event.getEventName() + " cannot be handled"));
        }
    }

    protected void publishAuthenticationData(AuthenticationData authenticationData) {
        block2: {
            try {
                Object[] payloadData = this.populatePayloadData(authenticationData);
                this.publishEvent(payloadData, authenticationData);
            }
            catch (IdentityRuntimeException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.error((Object)"Error while publishing authentication data", (Throwable)e);
            }
        }
    }

    protected Object[] populatePayloadData(AuthenticationData authenticationData) {
        String roleList = null;
        if ("LOCAL".equalsIgnoreCase(authenticationData.getIdentityProviderType())) {
            roleList = this.getCommaSeparatedUserRoles(authenticationData.getUserStoreDomain() + "/" + authenticationData.getUsername(), authenticationData.getTenantDomain());
        } else if (StringUtils.isNotEmpty((String)authenticationData.getLocalUsername())) {
            roleList = this.getCommaSeparatedUserRoles(authenticationData.getUserStoreDomain() + "/" + authenticationData.getLocalUsername(), authenticationData.getTenantDomain());
        }
        Object[] payloadData = new Object[]{authenticationData.getContextId(), authenticationData.getEventId(), authenticationData.getEventType(), authenticationData.isAuthnSuccess(), AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userName", (String)authenticationData.getUsername()), AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userName", (String)authenticationData.getLocalUsername()), AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.userStoreDomain", (String)authenticationData.getUserStoreDomain()), authenticationData.getTenantDomain(), authenticationData.getRemoteIp(), "NOT_AVAILABLE", authenticationData.getInboundProtocol(), AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.serviceprovider", (String)authenticationData.getServiceProvider()), authenticationData.isRememberMe(), authenticationData.isForcedAuthn(), authenticationData.isPassive(), AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.rolesCommaSeperated", (String)roleList), String.valueOf(authenticationData.getStepNo()), AuthnDataPublisherUtils.replaceIfNotAvailable((String)"ISAnalytics.DefaultValues.identityProvider", (String)authenticationData.getIdentityProvider()), authenticationData.isSuccess(), authenticationData.getAuthenticator(), authenticationData.isInitialLogin(), authenticationData.getIdentityProviderType(), System.currentTimeMillis()};
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The created payload: " + Arrays.asList(payloadData)));
        }
        return payloadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishEvent(Object[] payloadData, AuthenticationData authenticationData) {
        String[] publishingDomains = (String[])authenticationData.getParameter("tenantDomainNames");
        if (publishingDomains != null && publishingDomains.length > 0) {
            try {
                FrameworkUtils.startTenantFlow((String)"carbon.super");
                for (String publishingDomain : publishingDomains) {
                    Object[] metadataArray = AuthnDataPublisherUtils.getMetaDataArray((String)publishingDomain);
                    payloadData[1] = UUID.randomUUID().toString();
                    org.wso2.carbon.databridge.commons.Event event = new org.wso2.carbon.databridge.commons.Event("org.wso2.is.analytics.stream.OverallAuthentication:1.0.0", System.currentTimeMillis(), metadataArray, null, payloadData);
                    AnalyticsLoginDataPublishDataHolder.getInstance().getPublisherService().publish(event);
                    if (!LOG.isDebugEnabled() || event == null) continue;
                    LOG.debug((Object)("Sending out to publishing domain:" + publishingDomain + " \n event : " + event.toString()));
                }
            }
            finally {
                FrameworkUtils.endTenantFlow();
            }
        }
    }

    private String getCommaSeparatedUserRoles(String userName, String tenantDomain) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving roles for user " + userName + ", tenant domain " + tenantDomain));
        }
        if (tenantDomain == null || userName == null) {
            return "";
        }
        RegistryService registryService = AnalyticsLoginDataPublishDataHolder.getInstance().getRegistryService();
        RealmService realmService = AnalyticsLoginDataPublishDataHolder.getInstance().getRealmService();
        UserRealm realm = null;
        UserStoreManager userstore = null;
        try {
            realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
            if (realm != null) {
                userstore = realm.getUserStoreManager();
                if (userstore.isExistingUser(userName)) {
                    String[] newRoles = userstore.getRoleListOfUser(userName);
                    StringBuilder sb = new StringBuilder();
                    List externalRoles = AuthnDataPublisherUtils.filterRoles((String[])newRoles);
                    for (String role : externalRoles) {
                        sb.append(",").append(role);
                    }
                    if (sb.length() > 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Returning roles, " + sb.substring(1)));
                        }
                        return sb.substring(1);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No realm found. for tenant domain : " + tenantDomain + ". Hence no roles added"));
            }
        }
        catch (CarbonException e) {
            LOG.error((Object)("Error when getting realm for " + userName + "@" + tenantDomain), (Throwable)e);
        }
        catch (UserStoreException e) {
            LOG.error((Object)("Error when getting user store for " + userName + "@" + tenantDomain), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"No roles found. Returning empty string");
        }
        return "";
    }

    private boolean isAnalyticsLoginDataPublishingEnabled(Event event) throws IdentityEventException {
        if (this.configs.getModuleProperties() != null) {
            String handlerEnabled = this.configs.getModuleProperties().getProperty("analyticsLoginDataPublisher.enable");
            return Boolean.parseBoolean(handlerEnabled);
        }
        return false;
    }
}

