/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.memcached;

import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.StorageCapabilitiesEx;

public class MemcachedStorageCapabilities
implements StorageCapabilitiesEx {
    private static long defaultMaxValue = 0x100000L;
    @Positive
    private final long valueSize;

    public MemcachedStorageCapabilities() {
        this(defaultMaxValue);
    }

    public MemcachedStorageCapabilities(@Positive long maxValueSize) {
        Constraint.isGreaterThan(0L, maxValueSize, "Maximum value size must be a positive integer");
        this.valueSize = maxValueSize;
    }

    @Override
    public int getContextSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getKeySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getValueSize() {
        return this.valueSize;
    }

    @Override
    public boolean isServerSide() {
        return true;
    }

    @Override
    public boolean isClustered() {
        return true;
    }
}

