/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.RollbackException;
import javax.persistence.TypedQuery;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.AbstractStorageService;
import org.opensaml.storage.StorageCapabilitiesEx;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.VersionMismatchException;
import org.opensaml.storage.impl.JPAStorageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAStorageService
extends AbstractStorageService
implements StorageCapabilitiesEx {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JPAStorageService.class);
    @Nonnull
    private final EntityManagerFactory entityManagerFactory;
    @NonNegative
    private int transactionRetry = 3;

    public JPAStorageService(@Nonnull EntityManagerFactory factory) {
        this.entityManagerFactory = Constraint.isNotNull(factory, "EntityManagerFactory cannot be null");
        this.setContextSize(255);
        this.setKeySize(255);
        this.setValueSize(Integer.MAX_VALUE);
    }

    public int getTransactionRetry() {
        return this.transactionRetry;
    }

    public void setTransactionRetry(int retry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.transactionRetry = (int)Constraint.isGreaterThanOrEqual(0L, retry, "Transaction retry must be greater than or equal to zero");
    }

    @Override
    public boolean isServerSide() {
        return true;
    }

    @Override
    public boolean isClustered() {
        return true;
    }

    @Override
    protected void doDestroy() {
        if (this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
        super.doDestroy();
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<StorageRecord> readAll() throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            List<StorageRecord> list = this.executeNamedQuery(manager, "JPAStorageRecord.findAll", null, StorageRecord.class, LockModeType.PESSIMISTIC_READ);
            return list;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                try {
                    manager.close();
                }
                catch (Exception e) {
                    this.log.error("Error closing entity manager", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<StorageRecord> readAll(@Nonnull @NotEmpty String context) throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("context", context);
            List<StorageRecord> list = this.executeNamedQuery(manager, "JPAStorageRecord.findByContext", params, StorageRecord.class, LockModeType.PESSIMISTIC_READ);
            return list;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                try {
                    manager.close();
                }
                catch (Exception e) {
                    this.log.error("Error closing entity manager", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<String> readContexts() throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            List<String> list = this.executeNamedQuery(manager, "JPAStorageRecord.findAllContexts", null, String.class, LockModeType.OPTIMISTIC);
            return list;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                try {
                    manager.close();
                }
                catch (Exception e) {
                    this.log.error("Error closing entity manager", (Throwable)e);
                }
            }
        }
    }

    @Override
    @Nullable
    public StorageRecord read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        return this.readImpl(context, key, null).getSecond();
    }

    @Override
    @Nonnull
    public Pair<Long, StorageRecord> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive long version) throws IOException {
        return this.readImpl(context, key, version);
    }

    @Nonnull
    protected Pair<Long, StorageRecord> readImpl(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive Long version) throws IOException {
        EntityManager manager = null;
        EntityTransaction transaction = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            transaction = manager.getTransaction();
            transaction.begin();
            JPAStorageRecord entity = (JPAStorageRecord)manager.find(JPAStorageRecord.class, (Object)new JPAStorageRecord.RecordId(context, key), LockModeType.PESSIMISTIC_READ);
            if (entity == null) {
                this.log.debug("Read failed, key '{}' not found in context '{}'", (Object)key, (Object)context);
                Pair<Long, StorageRecord> pair = new Pair<Long, StorageRecord>();
                return pair;
            }
            Object exp = entity.getExpiration();
            if (exp != null && System.currentTimeMillis() >= (Long)exp) {
                this.log.debug("Read failed, key '{}' expired in context '{}'", (Object)key, (Object)context);
                Pair<Long, StorageRecord> e = new Pair<Long, StorageRecord>();
                return e;
            }
            if (version != null && entity.getVersion() == version.longValue()) {
                exp = new Pair<Long, Object>(version, null);
                return exp;
            }
            exp = new Pair<Long, JPAStorageRecord>(entity.getVersion(), entity);
            return exp;
        }
        catch (Exception e) {
            this.log.error("Error reading record '{}' in context '{}'", new Object[]{key, context, e});
            if (transaction != null && transaction.isActive()) {
                try {
                    transaction.rollback();
                }
                catch (Exception ex) {
                    this.log.error("Error rolling back transaction", (Throwable)e);
                }
            }
            throw new IOException(e);
        }
        finally {
            if (transaction != null && transaction.isActive() && !transaction.getRollbackOnly()) {
                try {
                    transaction.commit();
                }
                catch (Exception e) {
                    this.log.error("Error committing transaction", (Throwable)e);
                }
            }
            if (manager != null && manager.isOpen()) {
                try {
                    manager.close();
                }
                catch (Exception e) {
                    this.log.error("Error closing entity manager", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, value, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by update.", e);
        }
    }

    @Override
    @Nullable
    public Long updateWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        return this.updateImpl(version, context, key, value, expiration);
    }

    @Override
    public boolean updateExpiration(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Positive Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, null, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by update.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    protected Long updateImpl(@Nullable Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        EntityManager manager = null;
        int retry = -1;
        RollbackException lastThrown = null;
        do {
            EntityTransaction transaction = null;
            try {
                manager = this.entityManagerFactory.createEntityManager();
                transaction = manager.getTransaction();
                transaction.begin();
                JPAStorageRecord entity = (JPAStorageRecord)manager.find(JPAStorageRecord.class, (Object)new JPAStorageRecord.RecordId(context, key), LockModeType.PESSIMISTIC_WRITE);
                if (entity == null) {
                    this.log.debug("Update failed, key '{}' not found in context '{}'", (Object)key, (Object)context);
                    Long l = null;
                    return l;
                }
                Long exp = entity.getExpiration();
                if (exp != null && System.currentTimeMillis() >= exp) {
                    this.log.debug("Update failed, key '{}' expired in context '{}'", (Object)key, (Object)context);
                    Long e = null;
                    return e;
                }
                if (version != null && entity.getVersion() != version.longValue()) {
                    throw new VersionMismatchException();
                }
                if (value != null) {
                    entity.setValue(value);
                    entity.incrementVersion();
                }
                entity.setExpiration(expiration);
                manager.merge((Object)entity);
                transaction.commit();
                this.log.debug("Update record '{}' in context '{}' with expiration '{}'", new Object[]{key, context, expiration});
                exp = entity.getVersion();
                return exp;
            }
            catch (VersionMismatchException e) {
                throw e;
            }
            catch (RollbackException e) {
                lastThrown = e;
            }
            catch (Exception e) {
                this.log.error("Error updating record '{}' in context '{}'", new Object[]{key, context, e});
                if (transaction == null) throw new IOException(e);
                if (!transaction.isActive()) throw new IOException(e);
                try {
                    transaction.rollback();
                    throw new IOException(e);
                }
                catch (Exception ex) {
                    this.log.error("Error rolling back transaction", (Throwable)e);
                }
                throw new IOException(e);
            }
            finally {
                if (transaction != null && transaction.isActive() && !transaction.getRollbackOnly()) {
                    try {
                        transaction.commit();
                    }
                    catch (Exception e) {
                        this.log.error("Error committing transaction", (Throwable)e);
                    }
                }
            }
        } while (++retry < this.transactionRetry);
        throw lastThrown;
        finally {
            if (manager != null && manager.isOpen()) {
                try {
                    manager.close();
                }
                catch (Exception e) {
                    this.log.error("Error closing entity manager", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean deleteWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        return this.deleteImpl(version, context, key);
    }

    @Override
    public boolean delete(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        try {
            return this.deleteImpl(null, context, key);
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by delete.", e);
        }
    }

    protected boolean deleteImpl(@Nullable @Positive Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        EntityManager manager = null;
        int retry = -1;
        RollbackException lastThrown = null;
        do {
            boolean bl;
            EntityTransaction transaction = null;
            try {
                manager = this.entityManagerFactory.createEntityManager();
                transaction = manager.getTransaction();
                transaction.begin();
                JPAStorageRecord entity = (JPAStorageRecord)manager.find(JPAStorageRecord.class, (Object)new JPAStorageRecord.RecordId(context, key), LockModeType.PESSIMISTIC_WRITE);
                if (entity == null) {
                    this.log.debug("Deleting record '{}' in context '{}'....key not found", (Object)key, (Object)context);
                    boolean bl2 = false;
                    return bl2;
                }
                if (version != null && entity.getVersion() != version.longValue()) {
                    throw new VersionMismatchException();
                }
                manager.remove((Object)entity);
                transaction.commit();
                this.log.debug("Deleted record '{}' in context '{}'", (Object)key, (Object)context);
                bl = true;
            }
            catch (VersionMismatchException e) {
                throw e;
            }
            catch (RollbackException e) {
                lastThrown = e;
                continue;
            }
            catch (Exception e) {
                this.log.error("Error deleting record '{}' in context '{}'", new Object[]{key, context, e});
                if (transaction != null && transaction.isActive()) {
                    try {
                        transaction.rollback();
                    }
                    catch (Exception ex) {
                        this.log.error("Error rolling back transaction", (Throwable)e);
                    }
                }
                throw new IOException(e);
            }
            finally {
                if (transaction != null && transaction.isActive() && !transaction.getRollbackOnly()) {
                    try {
                        transaction.commit();
                    }
                    catch (Exception e) {
                        this.log.error("Error committing transaction", (Throwable)e);
                    }
                }
            }
            return bl;
        } while (++retry < this.transactionRetry);
        throw lastThrown;
        finally {
            if (manager != null && manager.isOpen()) {
                try {
                    manager.close();
                }
                catch (Exception e) {
                    this.log.error("Error closing entity manager", (Throwable)e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable @Positive Long expiration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void deleteContext(@Nonnull @NotEmpty String context) throws IOException {
        this.deleteContextImpl(context, null);
        this.log.debug("Deleted all entities in context '{}'", (Object)context);
    }

    @Override
    public void reap(@Nonnull @NotEmpty String context) throws IOException {
        this.deleteContextImpl(context, System.currentTimeMillis());
        this.log.debug("Reaped all entities in context '{}'", (Object)context);
    }

    /*
     * Exception decompiling
     */
    protected void deleteContextImpl(@Nonnull @NotEmpty String context, @Nonnull Long expiration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void deleteImpl(@Nonnull Long expiration) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> List<T> executeNamedQuery(@Nonnull EntityManager manager, @Nonnull @NotEmpty String query, @Nonnull Map<String, Object> params, @Nonnull Class<T> clazz, @Nonnull LockModeType lockMode) throws IOException {
        ArrayList results = new ArrayList();
        EntityTransaction transaction = null;
        try {
            transaction = manager.getTransaction();
            transaction.begin();
            TypedQuery queryResults = manager.createNamedQuery(query, clazz);
            queryResults.setLockMode(lockMode);
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    queryResults.setParameter(entry.getKey(), entry.getValue());
                }
            }
            results.addAll(queryResults.getResultList());
        }
        catch (Exception e) {
            this.log.error("Error executing named query", (Throwable)e);
            if (transaction != null && transaction.isActive()) {
                try {
                    transaction.rollback();
                }
                catch (Exception ex) {
                    this.log.error("Error rolling back transaction", (Throwable)e);
                }
            }
            throw new IOException(e);
        }
        finally {
            if (transaction != null && transaction.isActive() && !transaction.getRollbackOnly()) {
                try {
                    transaction.commit();
                }
                catch (Exception e) {
                    this.log.error("Error committing transaction", (Throwable)e);
                }
            }
        }
        return results;
    }

    @Override
    @Nullable
    protected TimerTask getCleanupTask() {
        return new TimerTask(){

            @Override
            public void run() {
                Long now = System.currentTimeMillis();
                JPAStorageService.this.log.debug("Running cleanup task at {}", (Object)now);
                try {
                    JPAStorageService.this.deleteImpl(now);
                }
                catch (IOException e) {
                    JPAStorageService.this.log.error("Error running cleanup task for {}", (Object)now, (Object)e);
                }
                JPAStorageService.this.log.debug("Finished cleanup task for {}", (Object)now);
            }
        };
    }
}

