/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.opensaml.storage.AbstractStorageService;
import org.opensaml.storage.MutableStorageRecord;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.VersionMismatchException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapBackedStorageService
extends AbstractStorageService {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractMapBackedStorageService.class);

    public AbstractMapBackedStorageService() {
        this.setContextSize(Integer.MAX_VALUE);
        this.setKeySize(Integer.MAX_VALUE);
        this.setValueSize(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        Lock writeLock = this.getLock().writeLock();
        try {
            Long exp;
            StorageRecord record;
            Map<String, Map<String, MutableStorageRecord>> contextMap;
            writeLock.lock();
            try {
                contextMap = this.getContextMap();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Map<String, MutableStorageRecord> dataMap = contextMap.get(context);
            if (dataMap == null) {
                dataMap = new HashMap<String, MutableStorageRecord>();
                contextMap.put(context, dataMap);
            }
            if ((record = (StorageRecord)dataMap.get(key)) != null && ((exp = record.getExpiration()) == null || System.currentTimeMillis() < exp)) {
                boolean bl = false;
                return bl;
            }
            dataMap.put(key, new MutableStorageRecord(value, expiration));
            this.log.trace("Inserted record '{}' in context '{}' with expiration '{}'", new Object[]{key, context, expiration});
            this.setDirty();
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    @Nullable
    public StorageRecord read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        return this.readImpl(context, key, null).getSecond();
    }

    @Override
    @Nonnull
    public Pair<Long, StorageRecord> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, long version) throws IOException {
        return this.readImpl(context, key, version);
    }

    @Override
    public boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, value, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IOException("Unexpected exception thrown by update.", e);
        }
    }

    @Override
    @Nullable
    public Long updateWithVersion(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable Long expiration) throws IOException, VersionMismatchException {
        return this.updateImpl(version, context, key, value, expiration);
    }

    @Override
    public boolean updateExpiration(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, null, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IOException("Unexpected exception thrown by update.", e);
        }
    }

    @Override
    public boolean deleteWithVersion(long version, String context, String key) throws IOException, VersionMismatchException {
        return this.deleteImpl(version, context, key);
    }

    @Override
    public boolean delete(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        try {
            return this.deleteImpl(null, context, key);
        }
        catch (VersionMismatchException e) {
            throw new IOException("Unexpected exception thrown by delete.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable Long expiration) throws IOException {
        Lock writeLock = this.getLock().writeLock();
        try {
            Map<String, Map<String, MutableStorageRecord>> contextMap;
            writeLock.lock();
            try {
                contextMap = this.getContextMap();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Map<String, MutableStorageRecord> dataMap = contextMap.get(context);
            if (dataMap != null) {
                this.setDirty();
                Long now = System.currentTimeMillis();
                for (MutableStorageRecord record : dataMap.values()) {
                    Long exp = record.getExpiration();
                    if (exp != null && now >= exp) continue;
                    record.setExpiration(expiration);
                }
                this.log.debug("Updated expiration of valid records in context '{}' to '{}'", (Object)context, (Object)expiration);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteContext(@Nonnull @NotEmpty String context) throws IOException {
        Lock writeLock = this.getLock().writeLock();
        try {
            writeLock.lock();
            this.setDirty();
            try {
                this.getContextMap().remove(context);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            writeLock.unlock();
        }
        this.log.debug("Deleted context '{}'", (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reap(@Nonnull @NotEmpty String context) throws IOException {
        Lock writeLock = this.getLock().writeLock();
        try {
            Map<String, Map<String, MutableStorageRecord>> contextMap;
            writeLock.lock();
            try {
                contextMap = this.getContextMap();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Map<String, MutableStorageRecord> dataMap = contextMap.get(context);
            if (dataMap != null && this.reapWithLock(dataMap, System.currentTimeMillis())) {
                this.setDirty();
                if (dataMap.isEmpty()) {
                    contextMap.remove(context);
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Nonnull
    protected abstract ReadWriteLock getLock();

    @Nonnull
    @NonnullElements
    @Live
    protected abstract Map<String, Map<String, MutableStorageRecord>> getContextMap();

    protected void setDirty() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Pair<Long, StorageRecord> readImpl(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable Long version) throws IOException {
        Lock readLock = this.getLock().readLock();
        try {
            Pair<Long, StorageRecord> pair;
            Map<String, Map<String, MutableStorageRecord>> contextMap;
            readLock.lock();
            try {
                contextMap = this.getContextMap();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Map<String, MutableStorageRecord> dataMap = contextMap.get(context);
            if (dataMap == null) {
                this.log.debug("Read failed, context '{}' not found", (Object)context);
                Pair<Long, StorageRecord> pair2 = new Pair<Long, StorageRecord>();
                return pair2;
            }
            StorageRecord record = dataMap.get(key);
            if (record == null) {
                this.log.debug("Read failed, key '{}' not found in context '{}'", (Object)key, (Object)context);
                Pair<Long, StorageRecord> pair3 = new Pair<Long, StorageRecord>();
                return pair3;
            }
            Long exp = record.getExpiration();
            if (exp != null && System.currentTimeMillis() >= exp) {
                this.log.debug("Read failed, key '{}' expired in context '{}'", (Object)key, (Object)context);
                Pair<Long, StorageRecord> pair4 = new Pair<Long, StorageRecord>();
                return pair4;
            }
            if (version != null && record.getVersion() == version.longValue()) {
                pair = new Pair<Long, Object>(version, null);
                return pair;
            }
            pair = new Pair<Long, StorageRecord>(record.getVersion(), record);
            return pair;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Long updateImpl(@Nullable Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable String value, @Nullable Long expiration) throws IOException, VersionMismatchException {
        Lock writeLock = this.getLock().writeLock();
        try {
            Map<String, Map<String, MutableStorageRecord>> contextMap;
            writeLock.lock();
            try {
                contextMap = this.getContextMap();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Map<String, MutableStorageRecord> dataMap = contextMap.get(context);
            if (dataMap == null) {
                this.log.debug("Update failed, context '{}' not found", (Object)context);
                Long l = null;
                return l;
            }
            MutableStorageRecord record = dataMap.get(key);
            if (record == null) {
                this.log.debug("Update failed, key '{}' not found in context '{}'", (Object)key, (Object)context);
                Long l = null;
                return l;
            }
            Long exp = record.getExpiration();
            if (exp != null && System.currentTimeMillis() >= exp) {
                this.log.debug("Update failed, key '{}' expired in context '{}'", (Object)key, (Object)context);
                Long l = null;
                return l;
            }
            if (version != null && version.longValue() != record.getVersion()) {
                throw new VersionMismatchException();
            }
            this.setDirty();
            if (value != null) {
                record.setValue(value);
                record.incrementVersion();
            }
            record.setExpiration(expiration);
            this.log.trace("Updated record '{}' in context '{}' with expiration '{}'", new Object[]{key, context, expiration});
            Long l = record.getVersion();
            return l;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteImpl(@Nullable @Positive Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        Lock writeLock = this.getLock().writeLock();
        try {
            Map<String, Map<String, MutableStorageRecord>> contextMap;
            writeLock.lock();
            try {
                contextMap = this.getContextMap();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            Map<String, MutableStorageRecord> dataMap = contextMap.get(context);
            if (dataMap == null) {
                this.log.debug("Deleting record '{}' in context '{}'....context not found", (Object)key, (Object)context);
                boolean bl = false;
                return bl;
            }
            MutableStorageRecord record = dataMap.get(key);
            if (record == null) {
                this.log.debug("Deleting record '{}' in context '{}'....key not found", (Object)key, (Object)context);
                boolean bl = false;
                return bl;
            }
            if (version != null && record.getVersion() != version.longValue()) {
                throw new VersionMismatchException();
            }
            this.setDirty();
            dataMap.remove(key);
            this.log.trace("Deleted record '{}' in context '{}'", (Object)key, (Object)context);
            if (dataMap.isEmpty()) {
                contextMap.remove(context);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    protected boolean reapWithLock(@Nonnull @NonnullElements Map<String, MutableStorageRecord> dataMap, final long expiration) {
        return Iterables.removeIf(dataMap.entrySet(), (Predicate)new Predicate<Map.Entry<String, MutableStorageRecord>>(){

            public boolean apply(@Nullable Map.Entry<String, MutableStorageRecord> entry) {
                Long exp = entry.getValue().getExpiration();
                return exp != null && exp <= expiration;
            }
        });
    }
}

