/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.pipeline;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.encoder.MessageEncoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.pipeline.MessagePipeline;

public class BasicMessagePipeline<InboundMessageType, OutboundMessageType>
implements MessagePipeline<InboundMessageType, OutboundMessageType> {
    private MessageEncoder<OutboundMessageType> encoder;
    private MessageDecoder<InboundMessageType> decoder;
    private MessageHandler<OutboundMessageType> outboundPayloadHandler;
    private MessageHandler<OutboundMessageType> outboundTransportHandler;
    private MessageHandler<InboundMessageType> inboundHandler;

    public BasicMessagePipeline(@Nonnull MessageEncoder<OutboundMessageType> newEncoder, @Nonnull MessageDecoder<InboundMessageType> newDecoder) {
        this.setEncoder(newEncoder);
        this.setDecoder(newDecoder);
    }

    @Override
    public MessageEncoder<OutboundMessageType> getEncoder() {
        return this.encoder;
    }

    protected void setEncoder(@Nonnull MessageEncoder<OutboundMessageType> newEncoder) {
        this.encoder = Constraint.isNotNull(newEncoder, "MessageEncoder can not be null");
    }

    @Override
    public MessageDecoder<InboundMessageType> getDecoder() {
        return this.decoder;
    }

    protected void setDecoder(@Nonnull MessageDecoder<InboundMessageType> newDecoder) {
        this.decoder = Constraint.isNotNull(newDecoder, "MessageDecoder can not be null");
    }

    @Override
    public MessageHandler<OutboundMessageType> getOutboundPayloadMessageHandler() {
        return this.outboundPayloadHandler;
    }

    public void setOutboundPayloadHandler(@Nullable MessageHandler<OutboundMessageType> handler) {
        this.outboundPayloadHandler = handler;
    }

    @Override
    public MessageHandler<OutboundMessageType> getOutboundTransportMessageHandler() {
        return this.outboundTransportHandler;
    }

    public void setOutboundTransportHandler(MessageHandler<OutboundMessageType> handler) {
        this.outboundTransportHandler = handler;
    }

    @Override
    public MessageHandler<InboundMessageType> getInboundMessageHandler() {
        return this.inboundHandler;
    }

    public void setInboundHandler(MessageHandler<InboundMessageType> handler) {
        this.inboundHandler = handler;
    }
}

