/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;

public final class CheckMandatoryIssuer
extends AbstractMessageHandler {
    @NonnullAfterInit
    private Function<MessageContext, String> issuerLookupStrategy;

    public void setIssuerLookupStrategy(@Nonnull Function<MessageContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.issuerLookupStrategy = Constraint.isNotNull(strategy, "Message context issuer lookup strategy cannot be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.issuerLookupStrategy == null) {
            throw new ComponentInitializationException("Message context issuer lookup strategy cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String issuer = (String)this.issuerLookupStrategy.apply((Object)messageContext);
        if (issuer == null) {
            throw new MessageHandlerException("Message context did not contain an issuer");
        }
    }
}

