/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.decoder.httpclient;

import java.io.InputStream;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.httpclient.AbstractHttpClientResponseMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class BaseHttpClientResponseXMLMessageDecoder<MessageType extends XMLObject>
extends AbstractHttpClientResponseMessageDecoder<MessageType> {
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    private final Logger log = LoggerFactory.getLogger(BaseHttpClientResponseXMLMessageDecoder.class);
    private ParserPool parserPool = XMLObjectProviderRegistrySupport.getParserPool();

    @Override
    public void decode() throws MessageDecodingException {
        this.log.debug("Beginning to decode message from HttpResponse");
        super.decode();
        this.logDecodedMessage();
        this.log.debug("Successfully decoded message from HttpResponse");
    }

    @Nonnull
    public ParserPool getParserPool() {
        return this.parserPool;
    }

    public void setParserPool(@Nonnull ParserPool pool) {
        Constraint.isNotNull(pool, "ParserPool cannot be null");
        this.parserPool = pool;
    }

    @Override
    protected void doDestroy() {
        this.parserPool = null;
        super.doDestroy();
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.parserPool == null) {
            throw new ComponentInitializationException("Parser pool cannot be null");
        }
    }

    protected void logDecodedMessage() {
        if (this.protocolMessageLog.isDebugEnabled()) {
            XMLObject message = this.getMessageToLog();
            if (message == null) {
                this.log.warn("Decoded message was null, nothing to log");
                return;
            }
            try {
                Element dom = XMLObjectSupport.marshall(message);
                this.protocolMessageLog.debug("\n" + SerializeSupport.prettyPrintXML(dom));
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            }
        }
    }

    protected XMLObject getMessageToLog() {
        return (XMLObject)this.getMessageContext().getMessage();
    }

    protected XMLObject unmarshallMessage(InputStream messageStream) throws MessageDecodingException {
        try {
            XMLObject message = XMLObjectSupport.unmarshallFromInputStream(this.getParserPool(), messageStream);
            return message;
        }
        catch (XMLParserException e) {
            this.log.error("Error unmarshalling message from input stream", (Throwable)e);
            throw new MessageDecodingException("Error unmarshalling message from input stream", e);
        }
        catch (UnmarshallingException e) {
            this.log.error("Error unmarshalling message from input stream", (Throwable)e);
            throw new MessageDecodingException("Error unmarshalling message from input stream", e);
        }
    }
}

