/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.analytics.publishers.impl;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.analytics.publisher.exception.MetricCreationException;
import org.wso2.am.analytics.publisher.reporter.CounterMetric;
import org.wso2.am.analytics.publisher.reporter.MetricReporter;
import org.wso2.am.analytics.publisher.reporter.MetricReporterFactory;
import org.wso2.am.analytics.publisher.reporter.MetricSchema;
import org.wso2.carbon.apimgt.common.analytics.AnalyticsCommonConfiguration;

public class AnalyticsDataPublisher {
    private static final Log log = LogFactory.getLog(AnalyticsDataPublisher.class);
    private static AnalyticsDataPublisher instance = new AnalyticsDataPublisher();
    private CounterMetric successMetricReporter;
    private CounterMetric faultyMetricReporter;

    private AnalyticsDataPublisher() {
    }

    public static AnalyticsDataPublisher getInstance() {
        return instance;
    }

    public void initialize(AnalyticsCommonConfiguration commonConfig) {
        Map<String, String> configs = commonConfig.getConfigurations();
        String reporterClass = configs.get("publisher.reporter.class");
        try {
            MetricReporter metricReporter = reporterClass != null ? MetricReporterFactory.getInstance().createMetricReporter(reporterClass, configs) : MetricReporterFactory.getInstance().createMetricReporter(configs);
            this.successMetricReporter = !StringUtils.isEmpty((CharSequence)commonConfig.getResponseSchema()) ? metricReporter.createCounterMetric("apim:response", MetricSchema.valueOf((String)commonConfig.getResponseSchema())) : metricReporter.createCounterMetric("apim:response", MetricSchema.RESPONSE);
            this.faultyMetricReporter = !StringUtils.isEmpty((CharSequence)commonConfig.getFaultSchema()) ? metricReporter.createCounterMetric("apim:faulty", MetricSchema.valueOf((String)commonConfig.getFaultSchema())) : metricReporter.createCounterMetric("apim:faulty", MetricSchema.ERROR);
        }
        catch (IllegalArgumentException | MetricCreationException e) {
            log.error((Object)"Error initializing event publisher.", e);
        }
    }

    public CounterMetric getSuccessMetricReporter() {
        if (this.successMetricReporter == null) {
            throw new RuntimeException("AnalyticsDataPublisher is not initialized.");
        }
        return this.successMetricReporter;
    }

    public CounterMetric getFaultyMetricReporter() {
        if (this.faultyMetricReporter == null) {
            throw new RuntimeException("AnalyticsDataPublisher is not initialized.");
        }
        return this.faultyMetricReporter;
    }
}

