/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.analytics.publishers.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.am.analytics.publisher.exception.MetricReportingException;
import org.wso2.am.analytics.publisher.reporter.CounterMetric;
import org.wso2.am.analytics.publisher.reporter.MetricEventBuilder;
import org.wso2.carbon.apimgt.common.analytics.publishers.RequestDataPublisher;
import org.wso2.carbon.apimgt.common.analytics.publishers.dto.Event;

public abstract class AbstractRequestDataPublisher
implements RequestDataPublisher {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final Log log = LogFactory.getLog(AbstractRequestDataPublisher.class);

    @Override
    public void publish(Event analyticsEvent) {
        CounterMetric counterMetric = this.getCounterMetric();
        if (counterMetric == null) {
            log.error((Object)"counterMetric cannot be null.");
            return;
        }
        Map dataMap = (Map)OBJECT_MAPPER.convertValue((Object)analyticsEvent, MAP_TYPE_REFERENCE);
        MetricEventBuilder builder = counterMetric.getEventBuilder();
        for (Map.Entry entry : dataMap.entrySet()) {
            try {
                builder.addAttribute((String)entry.getKey(), entry.getValue());
            }
            catch (MetricReportingException e) {
                log.error((Object)"Error adding data to the event stream.", (Throwable)e);
                return;
            }
        }
        try {
            counterMetric.incrementCount(builder);
        }
        catch (MetricReportingException e) {
            log.error((Object)"Error occurred when publishing event.", (Throwable)e);
        }
    }
}

