/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.analytics.collectors.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.common.analytics.collectors.AnalyticsDataProvider;
import org.wso2.carbon.apimgt.common.analytics.collectors.FaultDataCollector;
import org.wso2.carbon.apimgt.common.analytics.collectors.RequestDataCollector;
import org.wso2.carbon.apimgt.common.analytics.collectors.impl.CommonRequestDataCollector;
import org.wso2.carbon.apimgt.common.analytics.collectors.impl.fault.AuthFaultDataCollector;
import org.wso2.carbon.apimgt.common.analytics.collectors.impl.fault.TargetFaultDataCollector;
import org.wso2.carbon.apimgt.common.analytics.collectors.impl.fault.ThrottledFaultDataCollector;
import org.wso2.carbon.apimgt.common.analytics.collectors.impl.fault.UnclassifiedFaultDataCollector;
import org.wso2.carbon.apimgt.common.analytics.exceptions.AnalyticsException;
import org.wso2.carbon.apimgt.common.analytics.exceptions.DataNotFoundException;
import org.wso2.carbon.apimgt.common.analytics.publishers.dto.API;
import org.wso2.carbon.apimgt.common.analytics.publishers.dto.Event;
import org.wso2.carbon.apimgt.common.analytics.publishers.dto.MetaInfo;
import org.wso2.carbon.apimgt.common.analytics.publishers.dto.Target;

public class FaultyRequestDataCollector
extends CommonRequestDataCollector
implements RequestDataCollector {
    private static final Log log = LogFactory.getLog(FaultyRequestDataCollector.class);
    private FaultDataCollector authDataCollector;
    private FaultDataCollector throttledDataCollector;
    private FaultDataCollector targetDataCollector;
    private FaultDataCollector unclassifiedFaultDataCollector;
    private AnalyticsDataProvider provider;

    public FaultyRequestDataCollector(AnalyticsDataProvider provider) {
        super(provider);
        this.provider = provider;
        this.authDataCollector = new AuthFaultDataCollector(provider);
        this.throttledDataCollector = new ThrottledFaultDataCollector(provider);
        this.targetDataCollector = new TargetFaultDataCollector(provider);
        this.unclassifiedFaultDataCollector = new UnclassifiedFaultDataCollector(provider);
    }

    @Override
    public void collectData() throws AnalyticsException {
        log.debug((Object)"Handling faulty analytics types");
        Event faultyEvent = this.getFaultyEvent();
        switch (this.provider.getFaultType()) {
            case AUTH: {
                this.authDataCollector.collectFaultData(faultyEvent);
                break;
            }
            case THROTTLED: {
                this.throttledDataCollector.collectFaultData(faultyEvent);
                break;
            }
            case TARGET_CONNECTIVITY: {
                this.targetDataCollector.collectFaultData(faultyEvent);
                break;
            }
            case OTHER: {
                this.unclassifiedFaultDataCollector.collectFaultData(faultyEvent);
            }
        }
    }

    private Event getFaultyEvent() throws DataNotFoundException {
        long requestInTime = this.provider.getRequestTime();
        String offsetDateTime = FaultyRequestDataCollector.getTimeInISO(requestInTime);
        Event event = new Event();
        API api = this.provider.getApi();
        Target target = new Target();
        target.setTargetResponseCode(-1);
        MetaInfo metaInfo = this.provider.getMetaInfo();
        event.setApi(api);
        event.setTarget(target);
        event.setProxyResponseCode(this.provider.getProxyResponseCode());
        event.setRequestTimestamp(offsetDateTime);
        event.setMetaInfo(metaInfo);
        return event;
    }
}

