/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.core.internal.util;

import java.io.FileNotFoundException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.modules.JKSStore;
import org.wso2.andes.configuration.util.ConfigurationProperty;
import org.wso2.carbon.andes.core.QueueManagerException;
import org.wso2.carbon.andes.core.internal.ds.QueueManagerServiceValueHolder;
import org.wso2.carbon.andes.core.types.Queue;
import org.wso2.carbon.andes.core.types.Subscription;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;

public class Utils {
    private static final String DIRECT_EXCHANGE = "amq.direct";
    private static final String TOPIC_EXCHANGE = "amq.topic";
    private static final String ANDES_CONF_DIR = "/repository/conf/advanced/";
    private static final String ANDES_CONF_FILE = "qpid-config.xml";
    private static final String ANDES_CONF_CONNECTOR_NODE = "connector";
    private static final String ANDES_CONF_SSL_NODE = "ssl";
    private static final String CARBON_CLIENT_ID = "carbon";
    private static final String CARBON_VIRTUAL_HOST_NAME = "carbon";
    private static final int CHARACTERS_TO_SHOW = 15;
    public static final Integer MESSAGE_DISPLAY_LENGTH_MAX = (Integer)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.MANAGEMENT_CONSOLE_MAX_DISPLAY_LENGTH_FOR_MESSAGE_CONTENT);
    public static final String DISPLAY_CONTINUATION = "...";
    public static final String DISPLAY_LENGTH_EXCEEDED = "Message Content is too large to display.";

    public static UserRegistry getUserRegistry() throws RegistryException {
        RegistryService registryService = QueueManagerServiceValueHolder.getInstance().getRegistryService();
        return registryService.getGovernanceSystemRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());
    }

    public static String getTenantBasedQueueName(String queueName) {
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (tenantDomain != null && !queueName.contains(tenantDomain) && !tenantDomain.equals("carbon.super")) {
            queueName = tenantDomain + "/" + queueName;
        }
        return queueName;
    }

    public static String getTenantDomain() {
        return CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
    }

    public static boolean isAdmin(String username) throws QueueManagerException {
        boolean isAdmin = false;
        try {
            UserRealm userRealm = QueueManagerServiceValueHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String[] userRoles = userRealm.getUserStoreManager().getRoleListOfUser(username);
            String adminRole = userRealm.getRealmConfiguration().getAdminRoleName();
            for (String userRole : userRoles) {
                if (!userRole.equals(adminRole)) continue;
                isAdmin = true;
                break;
            }
        }
        catch (UserStoreException e) {
            throw new QueueManagerException("Failed to get list of user roles", e);
        }
        return isAdmin;
    }

    public static List<Queue> filterDomainSpecificQueues(List<Queue> fullList) {
        ArrayList<Queue> tenantFilteredQueues = new ArrayList<Queue>();
        for (Queue queue : fullList) {
            if (!Utils.isQueueInDomain(queue.getQueueName())) continue;
            tenantFilteredQueues.add(queue);
        }
        return tenantFilteredQueues;
    }

    public static Set<String> filterDomainSpecificQueues(Set<String> fullList) {
        HashSet<String> filteredQueues = new HashSet<String>();
        for (String queueName : fullList) {
            if (!Utils.isQueueInDomain(queueName)) continue;
            filteredQueues.add(queueName);
        }
        return filteredQueues;
    }

    public static boolean isQueueInDomain(String queueName) {
        String domainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        return !domainName.equals("carbon.super") ? queueName.startsWith(domainName) : !queueName.contains("/");
    }

    public static List<Subscription> filterDomainSpecificSubscribers(List<Subscription> allSubscriptions) {
        ArrayList<Subscription> tenantFilteredSubscriptions;
        block3: {
            String domainName;
            block2: {
                domainName = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                tenantFilteredSubscriptions = new ArrayList<Subscription>();
                if (domainName == null || CarbonContext.getThreadLocalCarbonContext().getTenantDomain().equals("carbon.super")) break block2;
                for (Subscription subscription : allSubscriptions) {
                    if (!subscription.getSubscribedQueueOrTopicName().startsWith(domainName + "/")) continue;
                    tenantFilteredSubscriptions.add(subscription);
                }
                break block3;
            }
            if (domainName == null || !CarbonContext.getThreadLocalCarbonContext().getTenantDomain().equals("carbon.super")) break block3;
            for (Subscription subscription : allSubscriptions) {
                if (subscription.getSubscribedQueueOrTopicName().contains("/")) continue;
                tenantFilteredSubscriptions.add(subscription);
            }
        }
        return tenantFilteredSubscriptions;
    }

    public static Subscription parseStringToASubscription(String subscriptionInfo) {
        String[] subInfo = subscriptionInfo.split(";");
        Subscription subscription = new Subscription();
        subscription.setSubscriptionIdentifier(subInfo[0]);
        subscription.setSubscribedQueueOrTopicName(subInfo[1]);
        subscription.setSubscriberQueueBoundExchange(subInfo[2]);
        subscription.setSubscriberQueueName(subInfo[3]);
        subscription.setDurable(Boolean.parseBoolean(subInfo[4]));
        subscription.setActive(Boolean.parseBoolean(subInfo[5]));
        subscription.setNumberOfMessagesRemainingForSubscriber(Integer.parseInt(subInfo[6]));
        subscription.setConnectedNodeAddress(subInfo[7]);
        subscription.setDestination(subInfo[8]);
        subscription.setProtocolType(subInfo[9]);
        subscription.setDestinationType(subInfo[10]);
        subscription.setOriginHostAddress(subInfo[11]);
        return subscription;
    }

    public static Object[] getFilteredMessagesList(ArrayList msgArrayList, int startingIndex, int maxMsgCount) {
        int resultSetSize = maxMsgCount;
        ArrayList resultList = new ArrayList();
        for (Object aMsg : msgArrayList) {
            resultList.add(aMsg);
        }
        if (resultList.size() - startingIndex < maxMsgCount) {
            resultSetSize = resultList.size() - startingIndex;
        }
        Object[] messageArray = new Object[resultSetSize];
        int index = 0;
        int msgDetailsIndex = 0;
        for (Object msgDetailOb : resultList) {
            if (startingIndex == index || startingIndex < index) {
                messageArray[msgDetailsIndex] = msgDetailOb;
                if (++msgDetailsIndex == maxMsgCount) break;
            }
            ++index;
        }
        return messageArray;
    }

    public static String getTCPConnectionURL(String userName, String accessKey) throws FileNotFoundException, XMLStreamException, UnknownHostException {
        String andesConfigHostAddress = String.valueOf(AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_BIND_ADDRESS));
        String hostAddress = InetAddress.getByName(andesConfigHostAddress).getHostAddress();
        Integer carbonPort = (Integer)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_DEFAULT_CONNECTION_PORT);
        String port = String.valueOf(carbonPort);
        String sslPort = String.valueOf(AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_PORT));
        JKSStore keyStore = (JKSStore)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_KEYSTORE);
        JKSStore trustStore = (JKSStore)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_TRUSTSTORE);
        if (Utils.isSSLOnly()) {
            return "amqp://" + userName + ":" + accessKey + "@" + "carbon" + "/" + "carbon" + "?brokerlist='tcp://" + hostAddress + ":" + sslPort + "?ssl='true'&trust_store='" + trustStore.getStoreLocation() + "'&trust_store_password='" + trustStore.getPassword() + "'&key_store='" + keyStore.getStoreLocation() + "'&key_store_password='" + keyStore.getPassword() + "''";
        }
        return "amqp://" + userName + ":" + accessKey + "@" + "carbon" + "/" + "carbon" + "?brokerlist='tcp://" + hostAddress + ":" + port + "'";
    }

    public static String getMsgProperties(Message message) throws JMSException {
        Enumeration propertiesEnu = message.getPropertyNames();
        StringBuilder sb = new StringBuilder("");
        if (propertiesEnu != null) {
            while (propertiesEnu.hasMoreElements()) {
                String propName = (String)propertiesEnu.nextElement();
                sb.append(propName).append(" = ").append(message.getStringProperty(propName));
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static String getMsgContentType(Message message) {
        String contentType = "";
        if (message instanceof TextMessage) {
            contentType = "Text";
        } else if (message instanceof ObjectMessage) {
            contentType = "Object";
        } else if (message instanceof MapMessage) {
            contentType = "Map";
        } else if (message instanceof StreamMessage) {
            contentType = "Stream";
        } else if (message instanceof BytesMessage) {
            contentType = "Byte";
        }
        return contentType;
    }

    public static String[] getMessageContentAsString(Message message) throws JMSException {
        String[] messageContent = new String[2];
        String summaryMsg = "";
        String wholeMsg = "";
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            if (message instanceof TextMessage) {
                String textMessage = ((TextMessage)message).getText();
                if (StringUtils.isNotEmpty((String)textMessage)) {
                    wholeMsg = StringEscapeUtils.escapeHtml((String)textMessage).trim();
                    summaryMsg = wholeMsg.length() >= 15 ? wholeMsg.substring(0, 15) : wholeMsg;
                    if (wholeMsg.length() > MESSAGE_DISPLAY_LENGTH_MAX) {
                        wholeMsg = wholeMsg.substring(0, MESSAGE_DISPLAY_LENGTH_MAX - 3) + DISPLAY_CONTINUATION + DISPLAY_LENGTH_EXCEEDED;
                    }
                }
            } else if (message instanceof ObjectMessage) {
                wholeMsg = "This Operation is Not Supported!";
                summaryMsg = "Not Supported";
            } else if (message instanceof MapMessage) {
                MapMessage mapMessage = (MapMessage)message;
                Enumeration mapEnu = mapMessage.getMapNames();
                while (mapEnu.hasMoreElements()) {
                    String mapName = (String)mapEnu.nextElement();
                    String mapVal = mapMessage.getObject(mapName).toString();
                    wholeMsg = StringEscapeUtils.escapeHtml((String)sb.append(mapName).append(": ").append(mapVal).append(", ").toString()).trim();
                }
                summaryMsg = wholeMsg.length() >= 15 ? wholeMsg.substring(0, 15) : wholeMsg;
            } else if (message instanceof StreamMessage) {
                ((StreamMessage)message).reset();
                wholeMsg = Utils.getContentFromStreamMessage((StreamMessage)message, sb).trim();
                summaryMsg = wholeMsg.length() >= 15 ? wholeMsg.substring(0, 15) : wholeMsg;
            } else if (message instanceof BytesMessage) {
                ((BytesMessage)message).reset();
                long messageLength = ((BytesMessage)message).getBodyLength();
                byte[] byteMsgArr = new byte[(int)messageLength];
                int index = ((BytesMessage)message).readBytes(byteMsgArr);
                for (int i = 0; i < index; ++i) {
                    wholeMsg = sb.append(byteMsgArr[i]).append(" ").toString().trim();
                }
                summaryMsg = wholeMsg.length() >= 15 ? wholeMsg.substring(0, 15) : wholeMsg;
            }
        }
        messageContent[0] = summaryMsg;
        messageContent[1] = wholeMsg;
        return messageContent;
    }

    private static String getContentFromStreamMessage(StreamMessage streamMessage, StringBuilder sb) throws JMSException {
        boolean eofReached = false;
        while (!eofReached) {
            try {
                Object obj = streamMessage.readObject();
                if (null == obj) continue;
                sb.append(obj.toString()).append(", ");
            }
            catch (MessageEOFException ex) {
                eofReached = true;
            }
        }
        return StringEscapeUtils.escapeHtml((String)sb.toString());
    }

    public static boolean isSSLOnly() throws FileNotFoundException, XMLStreamException {
        return (Boolean)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_SSL_CONNECTION_ENABLED) != false && (Boolean)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_AMQP_DEFAULT_CONNECTION_ENABLED) == false;
    }

    public static boolean isOwnDomain(String tenantDomain, String routingKey) {
        boolean isOwnDomain = false;
        if (tenantDomain != null) {
            if (routingKey.length() >= tenantDomain.length() + 1 && routingKey.substring(0, tenantDomain.length() + 1).equals(tenantDomain + "/")) {
                isOwnDomain = true;
            } else if (tenantDomain.equalsIgnoreCase("carbon.super") && !routingKey.contains("/")) {
                isOwnDomain = true;
            }
        } else if (!routingKey.contains("/")) {
            isOwnDomain = true;
        }
        return isOwnDomain;
    }
}

