/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.core.internal.registry;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.wso2.carbon.andes.core.SubscriptionManagerException;
import org.wso2.carbon.andes.core.internal.util.Utils;
import org.wso2.carbon.andes.core.types.Subscription;

public class SubscriptionManagementBeans {
    private static SubscriptionManagementBeans self = new SubscriptionManagementBeans();

    public static SubscriptionManagementBeans getInstance() {
        if (self == null) {
            self = new SubscriptionManagementBeans();
        }
        return self;
    }

    public ArrayList<Subscription> getSubscriptions(String isDurable, String isActive, String protocolType, String destinationType) throws SubscriptionManagerException {
        ArrayList<Subscription> subscriptionDetailsList = new ArrayList<Subscription>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=SubscriptionManagementInformation,name=SubscriptionManagementInformation");
            Object[] parameters = new Object[]{isDurable, isActive, protocolType, destinationType};
            String[] signature = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
            Object result = mBeanServer.invoke(objectName, "getSubscriptions", parameters, signature);
            if (result != null) {
                String[] subscriptionInformationList;
                for (String subscriptionInfo : subscriptionInformationList = (String[])result) {
                    Subscription sub = Utils.parseStringToASubscription(subscriptionInfo);
                    subscriptionDetailsList.add(sub);
                }
            }
            return subscriptionDetailsList;
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new SubscriptionManagerException("Error while invoking mBean operations to get subscription list", e);
        }
    }

    public long getPendingMessageCount(String queueName) throws SubscriptionManagerException {
        long messageCount = 0L;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=SubscriptionManagementInformation,name=SubscriptionManagementInformation");
            Object[] parameters = new Object[]{queueName};
            String[] signature = new String[]{String.class.getName()};
            Object result = mBeanServer.invoke(objectName, "getPendingMessageCount", parameters, signature);
            if (null != result) {
                messageCount = (Long)result;
            }
            return messageCount;
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new SubscriptionManagerException("Error while invoking mBean operations to get message count for a subscription", e);
        }
    }

    public ArrayList<Subscription> getFilteredSubscriptions(boolean isDurable, boolean isActive, String protocolType, String destinationType, String filteredNamePattern, boolean isFilteredNameByExactMatch, String identifierPattern, boolean isIdentifierPatternByExactMatch, String ownNodeId, int pageNumber, int subscriptionCountPerPage) throws SubscriptionManagerException {
        ArrayList<Subscription> subscriptionDetailsList = new ArrayList<Subscription>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=SubscriptionManagementInformation,name=SubscriptionManagementInformation");
            Object[] parameters = new Object[]{isDurable, isActive, protocolType, destinationType, filteredNamePattern, isFilteredNameByExactMatch, identifierPattern, isIdentifierPatternByExactMatch, ownNodeId, pageNumber, subscriptionCountPerPage};
            String[] signature = new String[]{Boolean.TYPE.getName(), Boolean.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), String.class.getName(), Boolean.TYPE.getName(), String.class.getName(), Integer.TYPE.getName(), Integer.TYPE.getName()};
            Object result = mBeanServer.invoke(objectName, "getFilteredSubscriptions", parameters, signature);
            if (null != result) {
                String[] subscriptionInformationList;
                for (String subscriptionInfo : subscriptionInformationList = (String[])result) {
                    Subscription sub = Utils.parseStringToASubscription(subscriptionInfo);
                    subscriptionDetailsList.add(sub);
                }
            }
            return subscriptionDetailsList;
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new SubscriptionManagerException("Error while invoking mBean operations to get subscription list", e);
        }
    }

    public int getTotalSubscriptionCountForSearchResult(boolean isDurable, boolean isActive, String protocolType, String destinationType, String filteredNamePattern, boolean isFilteredNameByExactMatch, String identifierPattern, boolean isIdentifierPatternByExactMatch, String ownNodeId) throws SubscriptionManagerException {
        int totalSubscriptionCount = 0;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=SubscriptionManagementInformation,name=SubscriptionManagementInformation");
            Object[] parameters = new Object[]{isDurable, isActive, protocolType, destinationType, filteredNamePattern, isFilteredNameByExactMatch, identifierPattern, isIdentifierPatternByExactMatch, ownNodeId};
            String[] signature = new String[]{Boolean.TYPE.getName(), Boolean.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName(), Boolean.TYPE.getName(), String.class.getName(), Boolean.TYPE.getName(), String.class.getName()};
            Object result = mBeanServer.invoke(objectName, "getTotalSubscriptionCountForSearchResult", parameters, signature);
            if (null != result) {
                totalSubscriptionCount = (Integer)result;
            }
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new SubscriptionManagerException("Error while invoking mBean operations to get subscription list", e);
        }
        return totalSubscriptionCount;
    }

    @Deprecated
    public ArrayList<Subscription> getAllSubscriptions() throws SubscriptionManagerException {
        ArrayList<Subscription> subscriptionDetailsList = new ArrayList<Subscription>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "AllSubscriptionInformation");
            if (result != null) {
                String[] subscriptionInformationList;
                for (String subscriptionInfo : subscriptionInformationList = (String[])result) {
                    Subscription sub = Utils.parseStringToASubscription(subscriptionInfo);
                    subscriptionDetailsList.add(sub);
                }
            }
            return subscriptionDetailsList;
        }
        catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new SubscriptionManagerException("Cannot access mBean operations to get subscription list", e);
        }
    }

    public void closeSubscription(String subscriptionID, String destination, String protocolType, String destinationType) throws SubscriptionManagerException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=SubscriptionManagementInformation,name=SubscriptionManagementInformation");
            Object[] parameters = new Object[]{subscriptionID, destination, protocolType, destinationType};
            String[] signature = new String[]{String.class.getName(), String.class.getName(), String.class.getName(), String.class.getName()};
            mBeanServer.invoke(objectName, "removeSubscription", parameters, signature);
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new SubscriptionManagerException("Cannot access mBean operations to get subscription list", e);
        }
    }
}

