/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.core.internal.registry;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.wso2.carbon.andes.core.QueueManagerException;
import org.wso2.carbon.andes.core.types.Message;
import org.wso2.carbon.andes.core.types.Queue;

public class QueueManagementBeans {
    private static QueueManagementBeans self;
    public static final String DIRECT_EXCHANGE = "amq.direct";
    public static final String DEFAULT_EXCHANGE = "<<default>>";

    public static QueueManagementBeans getInstance() {
        if (self == null) {
            self = new QueueManagementBeans();
        }
        return self;
    }

    public void createQueue(String queueName, String userName) throws QueueManagerException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=VirtualHost.VirtualHostManager,VirtualHost=\"carbon\"");
            String operationName = "createNewQueue";
            Object[] parameters = new Object[]{queueName, userName, true};
            String[] signature = new String[]{String.class.getName(), String.class.getName(), Boolean.TYPE.getName()};
            mBeanServer.invoke(objectName, operationName, parameters, signature);
            ObjectName bindingMBeanObjectName = new ObjectName("org.wso2.andes:type=VirtualHost.Exchange,VirtualHost=\"carbon\",name=\"amq.direct\",ExchangeType=direct");
            String bindingOperationName = "createNewBinding";
            Object[] bindingParams = new Object[]{queueName, queueName};
            String[] bpSignatures = new String[]{String.class.getName(), String.class.getName()};
            mBeanServer.invoke(bindingMBeanObjectName, bindingOperationName, bindingParams, bpSignatures);
        }
        catch (InstanceNotFoundException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot create Queue : " + queueName, e);
        }
        catch (MBeanException e) {
            throw new QueueManagerException(e.getCause().getMessage(), e);
        }
    }

    public List<Queue> getAllQueueCounts() throws QueueManagerException {
        ArrayList<Queue> queueList = new ArrayList<Queue>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "AllQueueCounts");
            if (result != null) {
                Map queueCountMap = (Map)result;
                for (Map.Entry entry : queueCountMap.entrySet()) {
                    Queue queue = new Queue();
                    queue.setQueueName((String)entry.getKey());
                    queue.setMessageCount(((Integer)entry.getValue()).intValue());
                    queueList.add(queue);
                }
            }
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot access mBean operations for message counts:", e);
        }
        catch (AttributeNotFoundException e) {
            throw new QueueManagerException("Incompatible attributes for operation to retrieve all queues", e);
        }
        return queueList;
    }

    public Queue getDLCQueue(String DLCQueueName) throws QueueManagerException {
        Queue DLCQueue = null;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "getDLCQueueInformation";
            Object[] parameters = new Object[]{DLCQueueName};
            String[] signature = new String[]{String.class.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                Map queueCountMap = (Map)result;
                for (Map.Entry entry : queueCountMap.entrySet()) {
                    Queue queue = new Queue();
                    queue.setQueueName((String)entry.getKey());
                    queue.setMessageCount((Long)entry.getValue());
                    DLCQueue = queue;
                }
            }
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot access mBean operations for message counts:", e);
        }
        return DLCQueue;
    }

    public long getMessageCount(String queueName, String msgPattern) throws QueueManagerException {
        long messageCount = 0L;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "getMessageCount";
            Object[] parameters = new Object[]{queueName, msgPattern};
            String[] signature = new String[]{String.class.getName(), String.class.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                messageCount = (Long)result;
            }
            return messageCount;
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Error while invoking mBean operations for message count:" + queueName, e);
        }
    }

    public void deleteQueue(String queueName) throws QueueManagerException {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("org.wso2.andes:type=VirtualHost.VirtualHostManager,VirtualHost=\"carbon\"");
            String operationName = "deleteQueue";
            Object[] parameters = new Object[]{queueName};
            String[] signature = new String[]{String.class.getName()};
            mBeanServer.invoke(objectName, operationName, parameters, signature);
        }
        catch (InstanceNotFoundException | MalformedObjectNameException e) {
            throw new QueueManagerException("Cannot delete Queue : " + queueName, e);
        }
        catch (JMException e) {
            throw new QueueManagerException(e.getCause().getMessage(), e);
        }
    }

    public void deleteMessagesFromDeadLetterQueue(long[] messageIDs, String destinationQueueName) throws QueueManagerException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "deleteMessagesFromDeadLetterQueue";
            Object[] parameters = new Object[]{messageIDs, destinationQueueName};
            String[] signature = new String[]{long[].class.getName(), String.class.getName()};
            mBeanServer.invoke(objectName, operationName, parameters, signature);
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Error deleting messages from Dead Letter Queue : " + destinationQueueName, e);
        }
    }

    public long restoreSelectedMessagesFromDeadLetterChannel(long[] messageIDs, String destinationQueueName) throws QueueManagerException {
        long unavailableMessageCount = 0L;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "restoreSelectedMessagesFromDeadLetterChannel";
            Object[] parameters = new Object[]{messageIDs, destinationQueueName};
            String[] signature = new String[]{long[].class.getName(), String.class.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                unavailableMessageCount = (Long)result;
            }
            return unavailableMessageCount;
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Error restoring messages from Dead Letter Queue : " + destinationQueueName, e);
        }
    }

    public long rerouteSelectedMessagesFromDeadLetterChannel(long[] messageIDs, String newDestinationQueueName, String destinationQueueName) throws QueueManagerException {
        long unavailableMessageCount = 0L;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "rerouteSelectedMessagesFromDeadLetterChannel";
            Object[] parameters = new Object[]{messageIDs, destinationQueueName, newDestinationQueueName};
            String[] signature = new String[]{long[].class.getName(), String.class.getName(), String.class.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (null != result) {
                unavailableMessageCount = (Long)result;
            }
            return unavailableMessageCount;
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Error restoring messages from Dead Letter Queue : " + destinationQueueName + " to " + newDestinationQueueName, e);
        }
    }

    public void purgeMessagesFromQueue(String queueName, String userName) throws QueueManagerException {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName bindingMBeanObjectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String bindingOperationName = "deleteAllMessagesInQueue";
            Object[] bindingParams = new Object[]{queueName, userName};
            String[] bpSignatures = new String[]{String.class.getName(), String.class.getName()};
            mBeanServer.invoke(bindingMBeanObjectName, bindingOperationName, bindingParams, bpSignatures);
        }
        catch (InstanceNotFoundException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot purge Queue : " + queueName, e);
        }
        catch (MBeanException e) {
            throw new QueueManagerException(e.getCause().getMessage(), e);
        }
    }

    public static boolean queueExists(String queueName) throws QueueManagerException {
        try {
            boolean status = false;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "isQueueExists";
            Object[] parameters = new Object[]{queueName};
            String[] signature = new String[]{String.class.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                status = (Boolean)result;
            }
            return status;
        }
        catch (JMException e) {
            throw new QueueManagerException("Error checking if queue " + queueName + " exists.", e);
        }
    }

    public List<Message> browseQueue(String queueName, long nextMessageIdToRead, int maxMessageCount) throws QueueManagerException {
        ArrayList<Message> browseMessageList = new ArrayList<Message>();
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "browseQueue";
            Object[] parameters = new Object[]{queueName, nextMessageIdToRead, maxMessageCount};
            String[] signature = new String[]{String.class.getName(), Long.TYPE.getName(), Integer.TYPE.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                CompositeData[] messageDataList;
                for (CompositeData messageData : messageDataList = (CompositeData[])result) {
                    Message message = new Message();
                    message.setMsgProperties((String)messageData.get("JMSProperties"));
                    message.setContentType((String)messageData.get("ContentType"));
                    message.setMessageContent((String[])messageData.get("Content"));
                    message.setJMSMessageId((String)messageData.get("JMSMessageId"));
                    message.setJMSReDelivered((Boolean)messageData.get("JMSRedelivered"));
                    message.setJMSTimeStamp((Long)messageData.get("TimeStamp"));
                    message.setDlcMsgDestination((String)messageData.get("MessageDestination"));
                    message.setAndesMsgMetadataId((Long)messageData.get("AndesMessageMetadataId"));
                    browseMessageList.add(message);
                }
            }
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot browse queue : " + queueName, e);
        }
        return browseMessageList;
    }

    public Set<String> getNamesOfAllDurableQueues() throws QueueManagerException {
        Set<String> namesOfDurableQueues = new HashSet<String>();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            Object result = mBeanServer.getAttribute(objectName, "NamesOfAllDurableQueues");
            if (result != null) {
                namesOfDurableQueues = (Set)result;
            }
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot access mBean operations for qet all queue names:", e);
        }
        catch (AttributeNotFoundException e) {
            throw new QueueManagerException("Incompatible attributes for operation to retrieve all queue names", e);
        }
        return namesOfDurableQueues;
    }
}

