/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.core.internal.ds;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.andes.core.SubscriptionManagerService;
import org.wso2.carbon.andes.core.internal.builder.SubscriptionManagerServiceBuilder;
import org.wso2.carbon.andes.core.internal.ds.SubscriptionManagerServiceValueHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="SubscriptionManagerService.component", immediate=true)
public class SubscriptionManagerServiceDS {
    public static Log log = LogFactory.getLog(SubscriptionManagerServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        try {
            SubscriptionManagerService subscriptionManagerService = SubscriptionManagerServiceBuilder.createSubscriptionManagerService();
            context.getBundleContext().registerService(SubscriptionManagerService.class.getName(), (Object)subscriptionManagerService, null);
            log.info((Object)"Successfully created the subscription manager service");
        }
        catch (RuntimeException e) {
            log.error((Object)"Can not create subscription manager service ", (Throwable)e);
        }
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        SubscriptionManagerServiceValueHolder.getInstance().registerRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        SubscriptionManagerServiceValueHolder.getInstance().registerRealmService(null);
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        SubscriptionManagerServiceValueHolder.getInstance().registerRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }

    @Reference(name="configurationcontext.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        SubscriptionManagerServiceValueHolder.getInstance().registerConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
    }
}

