/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.core;

import java.io.FileNotFoundException;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.queue.DLCQueueUtils;
import org.wso2.carbon.andes.commons.CommonsUtil;
import org.wso2.carbon.andes.commons.registry.RegistryClient;
import org.wso2.carbon.andes.commons.registry.RegistryClientException;
import org.wso2.carbon.andes.core.AndesException;
import org.wso2.carbon.andes.core.QueueManagerException;
import org.wso2.carbon.andes.core.QueueManagerService;
import org.wso2.carbon.andes.core.internal.ds.QueueManagerServiceValueHolder;
import org.wso2.carbon.andes.core.internal.registry.MessageStatusInformationBeans;
import org.wso2.carbon.andes.core.internal.registry.QueueManagementBeans;
import org.wso2.carbon.andes.core.internal.util.Utils;
import org.wso2.carbon.andes.core.types.Message;
import org.wso2.carbon.andes.core.types.Queue;
import org.wso2.carbon.andes.core.types.QueueRolePermission;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.authorization.TreeNode;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class QueueManagerServiceImpl
implements QueueManagerService {
    private static Log log = LogFactory.getLog(QueueManagerServiceImpl.class);
    private static final String PERMISSION_CHANGE_PERMISSION = "changePermission";
    private static final String ROLE_EVERY_ONE = "everyone";
    private static final String ANDES_ICF = "org.wso2.andes.jndi.PropertiesFileInitialContextFactory";
    private static final String CF_NAME_PREFIX = "connectionfactory.";
    private static final String QUEUE_NAME_PREFIX = "queue.";
    private static final String CF_NAME = "qpidConnectionfactory";
    protected static final String EVENT_TOPICS = "event/topics/";
    private static final String AT_REPLACE_CHAR = "_";
    private static final String QUEUE_ROLE_PREFIX = "Q_";
    public static final String DOMAIN_NAME_SEPARATOR = "!";

    @Override
    public void createQueue(String queueName) throws QueueManagerException {
        block4: {
            try {
                String tenantBasedQueueName = Utils.getTenantBasedQueueName(queueName);
                String userName = QueueManagerServiceImpl.getLoggedInUserName();
                if (!QueueManagementBeans.queueExists(tenantBasedQueueName)) {
                    RegistryClient.createQueue((String)tenantBasedQueueName, (String)userName);
                    QueueManagementBeans.getInstance().createQueue(tenantBasedQueueName, userName);
                    UserRealm userRealm = QueueManagerServiceValueHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
                    String queueID = CommonsUtil.getQueueID((String)queueName);
                    String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
                    if (!Utils.isAdmin(loggedInUser)) {
                        QueueManagerServiceImpl.authorizePermissionsToLoggedInUser(tenantBasedQueueName, queueID, userRealm);
                    }
                    break block4;
                }
                throw new QueueManagerException("Queue with the name: " + queueName + " already exists!");
            }
            catch (RegistryClientException | UserStoreException e) {
                throw new QueueManagerException("Error in creating the queue : " + queueName, e);
            }
        }
    }

    @Override
    public Queue getQueueByName(String queueName) throws QueueManagerException {
        QueueManagementBeans.getInstance();
        if (QueueManagementBeans.queueExists(queueName)) {
            Queue queue = new Queue(queueName);
            queue.setMessageCount(QueueManagementBeans.getInstance().getMessageCount(queueName, "queue"));
            if (Utils.isQueueInDomain(queue.getQueueName())) {
                return queue;
            }
        }
        return null;
    }

    @Override
    public Set<String> getNamesOfAllDurableQueues() throws QueueManagerException {
        Set<String> durableQueues = QueueManagementBeans.getInstance().getNamesOfAllDurableQueues();
        Utils.filterDomainSpecificQueues(durableQueues);
        return durableQueues;
    }

    @Override
    public Queue getDLCQueue(String tenantDomain) throws QueueManagerException {
        String tenantSpecificDLCQueueName = DLCQueueUtils.generateDLCQueueNameFromTenant((String)tenantDomain);
        return QueueManagementBeans.getInstance().getDLCQueue(tenantSpecificDLCQueueName);
    }

    @Override
    public List<Queue> getAllQueues() throws QueueManagerException {
        List<Queue> allQueues = QueueManagementBeans.getInstance().getAllQueueCounts();
        return Utils.filterDomainSpecificQueues(allQueues);
    }

    @Override
    public void deleteQueue(String queueName) throws QueueManagerException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            String resourcePath = "event/queues/jms/" + queueName;
            if (QueueManagementBeans.queueExists(queueName)) {
                QueueManagementBeans.getInstance().deleteQueue(queueName);
                userRegistry.delete(resourcePath);
            } else {
                log.warn((Object)("Queue: " + queueName + " does not exist. Cannot delete queue."));
            }
            QueueManagerServiceImpl.removeRoleCreatedForLoggedInUser(queueName);
        }
        catch (RegistryException e) {
            throw new QueueManagerException("Failed to delete queue : " + queueName, e);
        }
    }

    @Override
    public void deleteTopicFromRegistry(String topicName, String subscriptionId) throws QueueManagerException {
        try {
            UserRegistry userRegistry = Utils.getUserRegistry();
            String resourcePathForQueue = null;
            String resourcePathForTopic = null;
            if (subscriptionId.contains(":")) {
                resourcePathForQueue = "event/queues/jms/" + subscriptionId.split(":")[1];
                resourcePathForTopic = CommonsUtil.getSubscriptionID((String)topicName, (String)subscriptionId.split(":")[1]);
                userRegistry.delete(resourcePathForTopic);
                userRegistry.delete(resourcePathForQueue);
            } else if (subscriptionId.startsWith("tmp_")) {
                resourcePathForQueue = "event/queues/jms/" + subscriptionId;
                resourcePathForTopic = CommonsUtil.getSubscriptionID((String)topicName, (String)subscriptionId);
                userRegistry.delete(resourcePathForTopic);
                userRegistry.delete(resourcePathForQueue);
            }
            String userName = QueueManagerServiceImpl.getLoggedInUserName();
            if (Utils.isAdmin(userName)) {
                UserRealm userRealm = QueueManagerServiceValueHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
                String[] userRoles = userRealm.getUserStoreManager().getRoleListOfUser(userName);
                String adminRole = userRealm.getRealmConfiguration().getAdminRoleName();
                String role = null;
                for (String userRole : userRoles) {
                    if (!userRole.equals(adminRole)) continue;
                    role = userRole;
                    break;
                }
                userRealm.getAuthorizationManager().clearRoleAuthorization(role, resourcePathForQueue, TreeNode.Permission.CONSUME.toString().toLowerCase());
                userRealm.getAuthorizationManager().clearRoleAuthorization(role, EVENT_TOPICS + topicName, TreeNode.Permission.SUBSCRIBE.toString().toLowerCase());
                userRealm.getAuthorizationManager().clearRoleAuthorization(role, EVENT_TOPICS + topicName, TreeNode.Permission.PUBLISH.toString().toLowerCase());
                userRealm.getAuthorizationManager().clearRoleAuthorization(role, EVENT_TOPICS + topicName, PERMISSION_CHANGE_PERMISSION);
            }
        }
        catch (RegistryException | UserStoreException e) {
            String message = e.getMessage();
            throw new QueueManagerException("Failed to delete topic: " + topicName + " from registry " + message, e);
        }
    }

    @Override
    public long restoreSelectedMessagesFromDeadLetterChannel(long[] messageIDs, String destinationQueueName) throws QueueManagerException {
        return QueueManagementBeans.getInstance().restoreSelectedMessagesFromDeadLetterChannel(messageIDs, destinationQueueName);
    }

    @Override
    public long rerouteSelectedMessagesFromDeadLetterChannel(long[] messageIDs, String newDestinationQueueName, String destinationQueueName) throws QueueManagerException {
        return QueueManagementBeans.getInstance().rerouteSelectedMessagesFromDeadLetterChannel(messageIDs, newDestinationQueueName, destinationQueueName);
    }

    @Override
    public void deleteMessagesFromDeadLetterQueue(long[] messageIDs, String destinationQueueName) throws QueueManagerException {
        QueueManagementBeans.getInstance().deleteMessagesFromDeadLetterQueue(messageIDs, destinationQueueName);
    }

    @Override
    public void purgeMessagesOfQueue(String queueName) throws QueueManagerException {
        QueueManagementBeans.getInstance().purgeMessagesFromQueue(queueName, CarbonContext.getThreadLocalCarbonContext().getUsername());
    }

    @Override
    public long getMessageCount(String destinationName, String msgPattern) throws QueueManagerException {
        long messageCount = QueueManagementBeans.getInstance().getMessageCount(destinationName, msgPattern);
        return messageCount;
    }

    @Override
    public void updatePermission(String queueName, QueueRolePermission[] queueRolePermissions) throws QueueManagerException {
        String tenantBasedQueueName = Utils.getTenantBasedQueueName(queueName);
        if (QueueManagementBeans.queueExists(tenantBasedQueueName)) {
            String queueID = CommonsUtil.getQueueID((String)queueName);
            String loggedInUser = CarbonContext.getThreadLocalCarbonContext().getUsername();
            try {
                UserRealm userRealm = QueueManagerServiceValueHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
                boolean isUserHasChangePermission = false;
                if (Utils.isAdmin(loggedInUser)) {
                    isUserHasChangePermission = true;
                } else {
                    String[] userRoles;
                    String[] stringArray = userRoles = userRealm.getUserStoreManager().getRoleListOfUser(loggedInUser);
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String userRole = stringArray[i];
                        if (!userRealm.getAuthorizationManager().isRoleAuthorized(userRole, queueID, PERMISSION_CHANGE_PERMISSION)) continue;
                        isUserHasChangePermission = true;
                    }
                }
                if (!isUserHasChangePermission) {
                    throw new QueueManagerException(" User " + loggedInUser + " can not change the permissions of " + queueName);
                }
                for (QueueRolePermission queueRolePermission : queueRolePermissions) {
                    String role = queueRolePermission.getRoleName();
                    if (queueRolePermission.isAllowedToConsume()) {
                        userRealm.getAuthorizationManager().authorizeRole(role, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase());
                    } else {
                        userRealm.getAuthorizationManager().denyRole(role, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase());
                    }
                    if (queueRolePermission.isAllowedToPublish()) {
                        userRealm.getAuthorizationManager().authorizeRole(role, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase());
                        continue;
                    }
                    userRealm.getAuthorizationManager().denyRole(role, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase());
                }
            }
            catch (UserStoreException e) {
                throw new QueueManagerException("Unable to update permission of the queue.", e);
            }
        } else {
            throw new QueueManagerException("Queue with the name: " + queueName + " not already exists!");
        }
    }

    @Override
    public void addQueueAndAssignPermission(String queueName, QueueRolePermission[] queueRolePermissions) throws QueueManagerException {
        String tenantBasedQueueName = Utils.getTenantBasedQueueName(queueName);
        if (QueueManagementBeans.queueExists(tenantBasedQueueName)) {
            throw new QueueManagerException("Queue with the name: " + queueName + " already exists!");
        }
        this.createQueue(tenantBasedQueueName);
        this.updatePermission(tenantBasedQueueName, queueRolePermissions);
    }

    @Override
    public String[] getBackendRoles() throws QueueManagerException {
        UserRealm userRealm = CarbonContext.getThreadLocalCarbonContext().getUserRealm();
        String[] cleanedRoles = new String[]{};
        try {
            String adminRole = QueueManagerServiceValueHolder.getInstance().getRealmService().getBootstrapRealmConfiguration().getAdminRoleName();
            String[] allRoles = userRealm.getUserStoreManager().getRoleNames();
            if (allRoles != null && allRoles.length > 1) {
                ArrayList allRolesArrayList = new ArrayList();
                Collections.addAll(allRolesArrayList, allRoles);
                Iterator it = allRolesArrayList.iterator();
                while (it.hasNext()) {
                    String nextRole = (String)it.next();
                    if (!nextRole.equals(adminRole) && !nextRole.equals("system/wso2.anonymous.role")) continue;
                    it.remove();
                }
                cleanedRoles = allRolesArrayList.toArray(new String[allRolesArrayList.size()]);
            }
        }
        catch (UserStoreException e) {
            throw new QueueManagerException("Unable to get roles from user store", e);
        }
        return cleanedRoles;
    }

    @Override
    public QueueRolePermission[] getQueueRolePermission(String queueName) throws QueueManagerException {
        String tenantBasedQueueName = Utils.getTenantBasedQueueName(queueName);
        if (QueueManagementBeans.queueExists(tenantBasedQueueName)) {
            queueName = CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? queueName : queueName.replace(CarbonContext.getThreadLocalCarbonContext().getTenantDomain() + "/", "");
            String queueID = CommonsUtil.getQueueID((String)queueName);
            ArrayList<QueueRolePermission> queueRolePermissions = new ArrayList<QueueRolePermission>();
            try {
                UserRealm userRealm = QueueManagerServiceValueHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
                String adminRole = QueueManagerServiceValueHolder.getInstance().getRealmService().getBootstrapRealm().getRealmConfiguration().getAdminRoleName();
                for (String role : userRealm.getUserStoreManager().getRoleNames()) {
                    if (role.equals(adminRole) || "system/wso2.anonymous.role".equals(role)) continue;
                    QueueRolePermission queueRolePermission = new QueueRolePermission(role, userRealm.getAuthorizationManager().isRoleAuthorized(role, queueID, TreeNode.Permission.CONSUME.toString().toLowerCase()), userRealm.getAuthorizationManager().isRoleAuthorized(role, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase()));
                    queueRolePermissions.add(queueRolePermission);
                }
                return queueRolePermissions.toArray(new QueueRolePermission[queueRolePermissions.size()]);
            }
            catch (UserStoreException e) {
                throw new QueueManagerException("Unable to retrieve permission of the queue.", e);
            }
        }
        throw new QueueManagerException("Queue with the name: " + queueName + " not already exists!");
    }

    @Override
    public Message[] browseQueue(String nameOfQueue, long nextMessageIdToRead, int maxMsgCount) throws QueueManagerException {
        List<Message> messageList = QueueManagementBeans.getInstance().browseQueue(nameOfQueue, nextMessageIdToRead, maxMsgCount);
        return messageList.toArray(new Message[messageList.size()]);
    }

    @Override
    public long getTotalMessagesInQueue(String nameOfQueue) throws QueueManagerException {
        return QueueManagementBeans.getInstance().getMessageCount(nameOfQueue, "queue");
    }

    @Override
    public boolean sendMessage(String nameOfQueue, String userName, String accessKey, String jmsType, String jmsCorrelationID, int numberOfMessages, String message, int deliveryMode, int priority, long expireTime) throws QueueManagerException {
        String queueID = CommonsUtil.getQueueID((String)nameOfQueue);
        boolean isSend = false;
        try {
            UserRealm userRealm = QueueManagerServiceValueHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String tenantDomain = QueueManagerServiceValueHolder.getInstance().getRealmService().getTenantManager().getDomain(CarbonContext.getThreadLocalCarbonContext().getTenantId() <= 0 ? -1234 : CarbonContext.getThreadLocalCarbonContext().getTenantId());
            if (!Utils.isOwnDomain(tenantDomain, nameOfQueue)) {
                throw new QueueManagerException("Permission denied.");
            }
            if (Utils.isAdmin(userName)) {
                String formattedUserName = userName + DOMAIN_NAME_SEPARATOR + tenantDomain;
                this.send(nameOfQueue, formattedUserName, accessKey, jmsType, jmsCorrelationID, numberOfMessages, message, deliveryMode, priority, expireTime);
                isSend = true;
            } else if (userRealm.getAuthorizationManager().isUserAuthorized(userName, queueID, TreeNode.Permission.PUBLISH.toString().toLowerCase())) {
                String formattedUserName = userName + DOMAIN_NAME_SEPARATOR + tenantDomain;
                this.send(nameOfQueue, formattedUserName, accessKey, jmsType, jmsCorrelationID, numberOfMessages, message, deliveryMode, priority, expireTime);
                isSend = true;
            }
        }
        catch (UserStoreException e) {
            throw new QueueManagerException("Unable to send message.", e);
        }
        return isSend;
    }

    private void send(String nameOfQueue, String userName, String accessKey, String jmsType, String jmsCorrelationID, int numberOfMessages, String message, int deliveryMode, int priority, long expireTime) throws QueueManagerException {
        QueueConnection queueConnection = null;
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        try {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", ANDES_ICF);
            properties.put("connectionfactory.qpidConnectionfactory", Utils.getTCPConnectionURL(userName, accessKey));
            properties.put(QUEUE_NAME_PREFIX + nameOfQueue, nameOfQueue);
            properties.put("org.wso2.carbon.context.RequestBaseContext", "true");
            InitialContext ctx = new InitialContext(properties);
            QueueConnectionFactory connFactory = (QueueConnectionFactory)ctx.lookup(CF_NAME);
            queueConnection = connFactory.createQueueConnection();
            javax.jms.Queue queue = (javax.jms.Queue)ctx.lookup(nameOfQueue);
            queueSession = queueConnection.createQueueSession(false, 1);
            queueSender = queueSession.createSender(queue);
            queueConnection.start();
            TextMessage textMessage = queueSession.createTextMessage();
            if (queueSender != null && textMessage != null) {
                if (jmsType != null) {
                    textMessage.setJMSType(jmsType);
                }
                if (jmsCorrelationID != null) {
                    textMessage.setJMSCorrelationID(jmsCorrelationID);
                }
                if (message != null) {
                    textMessage.setText(message);
                } else {
                    textMessage.setText("Type message here..");
                }
                for (int i = 0; i < numberOfMessages; ++i) {
                    queueSender.send((javax.jms.Message)textMessage, deliveryMode, priority, expireTime);
                }
            }
        }
        catch (FileNotFoundException | UnknownHostException | JMSException | NamingException | XMLStreamException e) {
            throw new QueueManagerException("Unable to send message.", e);
        }
        finally {
            try {
                if (queueConnection != null) {
                    queueConnection.close();
                }
            }
            catch (JMSException e) {
                log.error((Object)"Unable to close queue connection", (Throwable)e);
            }
            try {
                if (queueSession != null) {
                    queueSession.close();
                }
            }
            catch (JMSException e) {
                log.error((Object)"Unable to close queue session", (Throwable)e);
            }
            try {
                if (queueSender != null) {
                    queueSender.close();
                }
            }
            catch (JMSException e) {
                log.error((Object)"Unable to close queue sender", (Throwable)e);
            }
        }
    }

    @Override
    public long getNumberOfMessagesInDLCForQueue(String queueName) throws QueueManagerException {
        long messageCount = 0L;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "getNumberOfMessagesInDLCForQueue";
            Object[] parameters = new Object[]{queueName};
            String[] signature = new String[]{String.class.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                messageCount = (Long)result;
            }
            return messageCount;
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot access mBean operations for message count in DLC for a queue:" + queueName, e);
        }
    }

    @Override
    public Message[] getMessagesInDLCForQueue(String queueName, long nextMessageIdToRead, int maxMessageCount) throws QueueManagerException {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "getMessagesInDLCForQueue";
            Object[] parameters = new Object[]{queueName, nextMessageIdToRead, maxMessageCount};
            String[] signature = new String[]{String.class.getName(), Long.TYPE.getName(), Integer.TYPE.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                CompositeData[] messageDataList;
                for (CompositeData messageData : messageDataList = (CompositeData[])result) {
                    Message message = new Message();
                    message.setMsgProperties((String)messageData.get("JMSProperties"));
                    message.setContentType((String)messageData.get("ContentType"));
                    message.setMessageContent((String[])messageData.get("Content"));
                    message.setJMSMessageId((String)messageData.get("JMSMessageId"));
                    message.setJMSReDelivered((Boolean)messageData.get("JMSRedelivered"));
                    message.setJMSTimeStamp((Long)messageData.get("TimeStamp"));
                    message.setDlcMsgDestination((String)messageData.get("MessageDestination"));
                    message.setAndesMsgMetadataId((Long)messageData.get("AndesMessageMetadataId"));
                    messageList.add(message);
                }
            }
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot get message in DLC for a queue : " + queueName, e);
        }
        return messageList.toArray(new Message[messageList.size()]);
    }

    @Override
    public void dumpMessageStatus() throws AndesException {
        MessageStatusInformationBeans.getInstance().dumpMessageStatusInformation();
    }

    private static String getLoggedInUserName() {
        String userName = CarbonContext.getThreadLocalCarbonContext().getTenantId() != -1234 ? CarbonContext.getThreadLocalCarbonContext().getUsername() + DOMAIN_NAME_SEPARATOR + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() : CarbonContext.getThreadLocalCarbonContext().getUsername();
        return userName.trim();
    }

    private static void authorizePermissionsToLoggedInUser(String queueName, String queueId, UserRealm userRealm) throws QueueManagerException {
        String newQueueName = queueName.replace("@", AT_REPLACE_CHAR);
        String username = CarbonContext.getThreadLocalCarbonContext().getUsername();
        try {
            String roleName = UserCoreUtil.addInternalDomainName((String)(QUEUE_ROLE_PREFIX + queueName.replace(".", "-").replace("/", "-")));
            UserStoreManager userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            if (userStoreManager.isExistingRole(roleName)) {
                throw new QueueManagerException("Unable to provide permissions to the user,  " + username + ", to subscribe and publish to " + newQueueName);
            }
            String[] user = new String[]{MultitenantUtils.getTenantAwareUsername((String)username)};
            userStoreManager.addRole(roleName, user, null);
            userRealm.getAuthorizationManager().authorizeRole(roleName, queueId, PERMISSION_CHANGE_PERMISSION);
            userRealm.getAuthorizationManager().authorizeRole(roleName, queueId, TreeNode.Permission.CONSUME.toString().toLowerCase());
            userRealm.getAuthorizationManager().authorizeRole(roleName, queueId, TreeNode.Permission.PUBLISH.toString().toLowerCase());
        }
        catch (UserStoreException e) {
            throw new QueueManagerException("Error while creating " + newQueueName, e);
        }
    }

    private static void removeRoleCreatedForLoggedInUser(String queueName) throws QueueManagerException {
        String newQueueName = queueName.replace("@", AT_REPLACE_CHAR);
        String roleName = UserCoreUtil.addInternalDomainName((String)(QUEUE_ROLE_PREFIX + newQueueName.replace(".", "-").replace("/", "-")));
        try {
            UserStoreManager userStoreManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager();
            if (userStoreManager.isExistingRole(roleName)) {
                userStoreManager.deleteRole(roleName);
            }
        }
        catch (UserStoreException e) {
            throw new QueueManagerException("Error while deleting " + newQueueName, e);
        }
    }

    @Override
    public Message[] getMessageMetadataInDLC(String targetQueue, long startMessageId, int pageLimit) throws QueueManagerException {
        ArrayList<Message> messageList = new ArrayList<Message>();
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "getMessageMetadataInDeadLetterChannel";
            Object[] parameters = new Object[]{targetQueue, startMessageId, pageLimit};
            String[] signature = new String[]{String.class.getName(), Long.TYPE.getName(), Integer.TYPE.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (result != null) {
                CompositeData[] messageDataList;
                for (CompositeData messageData : messageDataList = (CompositeData[])result) {
                    Message message = new Message();
                    message.setMsgProperties((String)messageData.get("JMSProperties"));
                    message.setContentType((String)messageData.get("ContentType"));
                    message.setMessageContent((String[])messageData.get("Content"));
                    message.setJMSMessageId((String)messageData.get("JMSMessageId"));
                    message.setJMSReDelivered((Boolean)messageData.get("JMSRedelivered"));
                    message.setJMSTimeStamp((Long)messageData.get("TimeStamp"));
                    message.setDlcMsgDestination((String)messageData.get("MessageDestination"));
                    message.setAndesMsgMetadataId((Long)messageData.get("AndesMessageMetadataId"));
                    messageList.add(message);
                }
            }
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Cannot get message metadata in DLC for queue : " + targetQueue, e);
        }
        return messageList.toArray(new Message[messageList.size()]);
    }

    @Override
    public int rerouteMessagesFromDeadLetterChannelForQueue(String sourceQueue, String targetQueue, int internalBatchSize) throws QueueManagerException {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("org.wso2.andes:type=QueueManagementInformation,name=QueueManagementInformation");
            String operationName = "rerouteAllMessagesInDeadLetterChannelForQueue";
            Object[] parameters = new Object[]{sourceQueue, targetQueue, internalBatchSize};
            String[] signature = new String[]{String.class.getName(), String.class.getName(), Integer.TYPE.getName()};
            Object result = mBeanServer.invoke(objectName, operationName, parameters, signature);
            if (null != result) {
                return (Integer)result;
            }
            return -1;
        }
        catch (InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            throw new QueueManagerException("Could not move messages in DLC for queue : " + sourceQueue + " to target queue : " + targetQueue, e);
        }
    }
}

