/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.client.authn.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.wso2.carbon.identity.oauth2.bean.OAuthClientAuthnContext;
import org.wso2.carbon.identity.oauth2.client.authentication.OAuthClientAuthnService;

public class OAuthClientAuthenticatorProxy
extends AbstractPhaseInterceptor<Message> {
    private static final Log log = LogFactory.getLog(OAuthClientAuthenticatorProxy.class);
    private static final String HTTP_REQUEST = "HTTP.REQUEST";
    private OAuthClientAuthnService oAuthClientAuthnService;

    public OAuthClientAuthenticatorProxy() {
        super("pre-invoke");
    }

    public OAuthClientAuthnService getOAuthClientAuthnService() {
        return this.oAuthClientAuthnService;
    }

    public void setOAuthClientAuthnService(OAuthClientAuthnService oAuthClientAuthnService) {
        this.oAuthClientAuthnService = oAuthClientAuthnService;
    }

    public void handleMessage(Message message) {
        Map<String, List> bodyContentParams = this.getContentParams(message);
        HttpServletRequest request = (HttpServletRequest)message.get((Object)HTTP_REQUEST);
        OAuthClientAuthnContext oAuthClientAuthnContext = this.oAuthClientAuthnService.authenticateClient(request, bodyContentParams);
        if (!oAuthClientAuthnContext.isPreviousAuthenticatorEngaged()) {
            oAuthClientAuthnContext.setErrorCode("invalid_client");
            oAuthClientAuthnContext.setErrorMessage("Unsupported client authentication mechanism");
        }
        this.setContextToRequest(request, oAuthClientAuthnContext);
    }

    protected Map<String, List> getContentParams(Message message) {
        HashMap<String, List> contentMap = new HashMap<String, List>();
        List contentList = (List)message.getContent(List.class);
        contentList.forEach(item -> {
            if (item instanceof MetadataMap) {
                MetadataMap metadataMap = (MetadataMap)item;
                metadataMap.forEach((key, value) -> {
                    if (key instanceof String && value instanceof List) {
                        contentMap.put((String)key, (List)value);
                    }
                });
            }
        });
        return contentMap;
    }

    private void setContextToRequest(HttpServletRequest request, OAuthClientAuthnContext oAuthClientAuthnContext) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting OAuth client authentication context to request");
        }
        request.setAttribute("oauth.client.authentication.context", (Object)oAuthClientAuthnContext);
    }
}

