/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.mgt.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sts.mgt.stub.IdentitySTSAdminServiceStub;
import org.wso2.carbon.identity.sts.mgt.stub.dto.CardIssuerDTO;
import org.wso2.carbon.identity.sts.mgt.stub.dto.CardIssuerTokenDTO;

public class STSAdminServiceClient {
    private static final Log log = LogFactory.getLog(STSAdminServiceClient.class);
    private IdentitySTSAdminServiceStub stub;

    public STSAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "IdentitySTSAdminService";
        this.stub = new IdentitySTSAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public CardIssuerDTO readCardIssuerConfiguration() throws AxisFault {
        try {
            return this.stub.readCardIssuerConfiguration();
        }
        catch (Exception e) {
            this.handleException("Error ouccured while reading card issuer configurations from the backend service", e);
            return null;
        }
    }

    public void updateCardIssueConfiguration(CardIssuerDTO issuer) throws AxisFault {
        try {
            this.stub.updateCardIssueConfiguration(issuer);
        }
        catch (Exception e) {
            this.handleException("Error ouccured while updating card issuer configurations at the backend service", e);
        }
    }

    public String getSupportingTokens(CardIssuerTokenDTO[] tokens) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < tokens.length; ++i) {
            if (!tokens[i].getSupported()) continue;
            if (i < tokens.length - 1) {
                buffer.append(tokens[i].getTokenType() + ",");
                continue;
            }
            buffer.append(tokens[i].getTokenType());
        }
        return buffer.toString();
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

