/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.mgt.ui.client;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.sts.mgt.stub.generic.STSAdminServiceStub;
import org.wso2.carbon.identity.sts.mgt.stub.service.util.xsd.TrustedServiceData;
import org.wso2.carbon.ui.CarbonUIUtil;

public class CarbonSTSClient {
    private static final Log log = LogFactory.getLog(CarbonSTSClient.class);
    private STSAdminServiceStub stub;
    private String serviceEndPoint;
    private ConfigurationContext configContext = null;

    public CarbonSTSClient(ServletConfig config, HttpSession session, String cookie) throws Exception {
        ServiceClient client = null;
        Options option = null;
        String serverUrl = null;
        this.configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        serverUrl = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        this.serviceEndPoint = serverUrl + "STSAdminService";
        try {
            this.stub = new STSAdminServiceStub(this.configContext, this.serviceEndPoint);
        }
        catch (AxisFault e) {
            log.error((Object)"Error while creating STSAdminServiceStub", (Throwable)e);
            throw new Exception(e);
        }
        client = this.stub._getServiceClient();
        option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getAliasFromPrimaryKeystore() throws Exception {
        try {
            return this.stub.getCertAliasOfPrimaryKeyStore();
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving primary key stores", (Throwable)e);
            throw e;
        }
    }

    public TrustedServiceData[] getTrustedServices() throws Exception {
        try {
            return this.stub.getTrustedServices();
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving trusted services", (Throwable)e);
            throw e;
        }
    }

    public void addTrustedService(String endpoint, String keyAlias) throws Exception {
        try {
            if (endpoint != null && endpoint.trim().length() > 0 && keyAlias != null && keyAlias.trim().length() > 0) {
                this.stub.addTrustedService(endpoint.trim(), keyAlias);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while adding trusted services", (Throwable)e);
            throw e;
        }
    }

    public void removeTrustedService(String endpoint) throws Exception {
        try {
            if (endpoint != null && endpoint.trim().length() > 0) {
                this.stub.removeTrustedService(endpoint);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while removing trusted services", (Throwable)e);
            throw e;
        }
    }

    private boolean isValidCookieSet() {
        return this.stub._getServiceClient().getOptions().getProperty("Cookie") != null;
    }
}

