/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Service;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.CollectionAdapter;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.Provider;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.RequestProcessor;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetBuilder;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.Transactional;
import org.apache.abdera.protocol.server.WorkspaceInfo;
import org.apache.abdera.protocol.server.WorkspaceManager;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.SimpleSubjectResolver;
import org.apache.abdera.protocol.server.processors.CategoriesRequestProcessor;
import org.apache.abdera.protocol.server.processors.CollectionRequestProcessor;
import org.apache.abdera.protocol.server.processors.EntryRequestProcessor;
import org.apache.abdera.protocol.server.processors.MediaRequestProcessor;
import org.apache.abdera.protocol.server.processors.ServiceRequestProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProvider
implements Provider {
    private static final Log log = LogFactory.getLog(AbstractProvider.class);
    protected Abdera abdera;
    protected Map<String, String> properties;
    protected List<Filter> filters = new ArrayList<Filter>();
    protected Map<TargetType, RequestProcessor> requestProcessors = new HashMap<TargetType, RequestProcessor>();

    protected AbstractProvider() {
        this.requestProcessors.put(TargetType.TYPE_SERVICE, new ServiceRequestProcessor());
        this.requestProcessors.put(TargetType.TYPE_CATEGORIES, new CategoriesRequestProcessor());
        this.requestProcessors.put(TargetType.TYPE_COLLECTION, new CollectionRequestProcessor());
        this.requestProcessors.put(TargetType.TYPE_ENTRY, new EntryRequestProcessor());
        this.requestProcessors.put(TargetType.TYPE_MEDIA, new MediaRequestProcessor());
    }

    @Override
    public void init(Abdera abdera, Map<String, String> properties) {
        this.abdera = abdera;
        this.properties = properties;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public Abdera getAbdera() {
        return this.abdera;
    }

    @Override
    public Subject resolveSubject(RequestContext request) {
        Resolver<Subject> subjectResolver = this.getSubjectResolver(request);
        return subjectResolver != null ? subjectResolver.resolve(request) : null;
    }

    @Override
    public Target resolveTarget(RequestContext request) {
        Resolver<Target> targetResolver = this.getTargetResolver(request);
        return targetResolver != null ? targetResolver.resolve(request) : null;
    }

    @Override
    public String urlFor(RequestContext request, Object key, Object param) {
        TargetBuilder tm = this.getTargetBuilder(request);
        return tm != null ? tm.urlFor(request, key, param) : null;
    }

    protected Resolver<Subject> getSubjectResolver(RequestContext request) {
        return new SimpleSubjectResolver();
    }

    protected abstract TargetBuilder getTargetBuilder(RequestContext var1);

    protected abstract Resolver<Target> getTargetResolver(RequestContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext process(RequestContext request) {
        Target target = request.getTarget();
        if (target == null || target.getType() == TargetType.TYPE_NOT_FOUND) {
            return ProviderHelper.notfound(request);
        }
        TargetType type = target.getType();
        RequestProcessor processor = this.requestProcessors.get(type);
        if (processor == null) {
            return ProviderHelper.notfound(request);
        }
        WorkspaceManager wm = this.getWorkspaceManager(request);
        CollectionAdapter adapter = wm.getCollectionAdapter(request);
        Transactional transaction = adapter instanceof Transactional ? (Transactional)((Object)adapter) : null;
        ResponseContext response = null;
        try {
            this.transactionStart(transaction, request);
            response = processor.process(request, wm, adapter);
            response = response != null ? response : this.processExtensionRequest(request, adapter);
            this.transactionEnd(transaction, request, response);
        }
        catch (Throwable e) {
            try {
                if (e instanceof ResponseContextException) {
                    ResponseContextException rce = (ResponseContextException)e;
                    if (rce.getStatusCode() >= 400 && rce.getStatusCode() < 500) {
                        log.info((Object)e);
                    } else {
                        log.error((Object)e);
                    }
                } else {
                    log.error((Object)e);
                }
                this.transactionCompensate(transaction, request, e);
                ResponseContext responseContext = response = this.createErrorResponse(request, e);
                this.transactionEnd(transaction, request, response);
                return responseContext;
            }
            catch (Throwable throwable) {
                this.transactionEnd(transaction, request, response);
                throw throwable;
            }
        }
        return response != null ? response : ProviderHelper.badrequest(request);
    }

    protected ResponseContext createErrorResponse(RequestContext request, Throwable e) {
        return ProviderHelper.servererror(request, e);
    }

    protected void transactionCompensate(Transactional transactional, RequestContext request, Throwable e) {
        if (transactional != null) {
            transactional.compensate(request, e);
        }
    }

    protected void transactionEnd(Transactional transactional, RequestContext request, ResponseContext response) {
        if (transactional != null) {
            transactional.end(request, response);
        }
    }

    protected void transactionStart(Transactional transactional, RequestContext request) throws ResponseContextException {
        if (transactional != null) {
            transactional.start(request);
        }
    }

    protected ResponseContext processExtensionRequest(RequestContext context, CollectionAdapter adapter) {
        return adapter.extensionRequest(context);
    }

    protected abstract WorkspaceManager getWorkspaceManager(RequestContext var1);

    protected Service getServiceElement(RequestContext request) {
        Service service = this.abdera.newService();
        for (WorkspaceInfo wi : this.getWorkspaceManager(request).getWorkspaces(request)) {
            service.addWorkspace(wi.asWorkspaceElement(request));
        }
        return service;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    @Override
    public Filter[] getFilters(RequestContext request) {
        return this.filters.toArray(new Filter[this.filters.size()]);
    }

    public void addFilter(Filter ... filters) {
        for (Filter filter : filters) {
            this.filters.add(filter);
        }
    }

    @Override
    public void setRequestProcessors(Map<TargetType, RequestProcessor> requestProcessors) {
        this.requestProcessors.clear();
        this.requestProcessors.putAll(requestProcessors);
    }

    @Override
    public void addRequestProcessors(Map<TargetType, RequestProcessor> requestProcessors) {
        this.requestProcessors.putAll(requestProcessors);
    }

    @Override
    public Map<TargetType, RequestProcessor> getRequestProcessors() {
        return Collections.unmodifiableMap(this.requestProcessors);
    }
}

