/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.wsdl.WSDL2Java;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CodegenHelper {
    private static Log log = LogFactory.getLog(CodegenHelper.class);
    private static final String SET = "set";

    private OMElement loadCodegenXML(String codegenXML) throws Exception {
        InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(codegenXML);
        if (inStream == null) {
            File inFile = new File(codegenXML);
            if (!inFile.exists()) {
                throw new Exception("Null input stream. Codegen XML " + codegenXML + " file not found.");
            }
            inStream = new FileInputStream(inFile);
        }
        StAXOMBuilder builder = new StAXOMBuilder(inStream);
        return builder.getDocumentElement();
    }

    private List parse(OMElement document) {
        ArrayList mainList = new ArrayList();
        Iterator childrenWithNameSetIte = document.getChildrenWithName(new QName(SET));
        while (childrenWithNameSetIte.hasNext()) {
            OMElement setElement = (OMElement)childrenWithNameSetIte.next();
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iter = setElement.getChildElements();
            while (iter.hasNext()) {
                OMElement ele = (OMElement)iter.next();
                arrayList.add("-" + ele.getLocalName());
                String value = ele.getText().trim();
                if (value.length() == 0) continue;
                arrayList.add(value);
            }
            mainList.add(arrayList);
        }
        return mainList;
    }

    public void execute(String codegenXML) throws Exception {
        OMElement document = this.loadCodegenXML(codegenXML);
        List setArrayList = this.parse(document);
        for (int i = 0; i < setArrayList.size(); ++i) {
            ArrayList setList = (ArrayList)setArrayList.get(i);
            String[] wsdl2JavaArgs = setList.toArray(new String[setList.size()]);
            CodegenHelper.generateCode(wsdl2JavaArgs);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(setArrayList.get(i) + " processed successfully."));
        }
    }

    private static synchronized void generateCode(String[] wsdl2JavaArgs) throws Exception {
        WSDL2Java.main((String[])wsdl2JavaArgs);
    }

    public static void main(String[] args) {
        System.out.println("Starting Codegen ...");
        if (args.length < 1) {
            System.out.println("Please provide the codegen XML file path");
        }
        System.out.println("Generating code for " + args[0]);
        try {
            CodegenHelper codegenHelper = new CodegenHelper();
            codegenHelper.execute(args[0]);
            System.out.println("Codegen completed successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

