/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class PasswordPrompt
implements Runnable {
    private static final int PROMPT_CLEARANCE_LENGTH = 10;
    private volatile boolean done = false;
    private String prompt;
    private PrintWriter out;

    public PasswordPrompt(String prompt, PrintWriter out) {
        this.prompt = prompt;
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int priority = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(10);
            String fullPrompt = "\r" + this.prompt + "          \r" + this.prompt;
            StringBuffer clearline = new StringBuffer();
            clearline.append('\r');
            for (int i = this.prompt.length() + 10; i >= 0; --i) {
                clearline.append(' ');
            }
            while (!this.done) {
                this.out.print(fullPrompt);
                this.out.flush();
                Thread.sleep(1L);
            }
            this.out.print(clearline.toString());
            this.out.flush();
            this.out.println();
            this.out.flush();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Thread.currentThread().setPriority(priority);
        }
        this.prompt = null;
        this.out = null;
    }

    public String getPassword(BufferedReader in) throws IOException {
        Thread t = new Thread((Runnable)this, "Password hiding thread");
        t.start();
        String password = in.readLine();
        this.done = true;
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return password;
    }
}

