/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.tracing.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.tracing.JaegerTracer;
import org.wso2.carbon.apimgt.tracing.LogTracer;
import org.wso2.carbon.apimgt.tracing.OpenTracer;
import org.wso2.carbon.apimgt.tracing.TracingService;
import org.wso2.carbon.apimgt.tracing.TracingServiceImpl;
import org.wso2.carbon.apimgt.tracing.ZipkinTracer;
import org.wso2.carbon.apimgt.tracing.internal.ServiceReferenceHolder;

@Component(name="org.wso2.carbon.apimgt.tracing.internal.TracingServiceComponent", immediate=true)
public class TracingServiceComponent {
    private static final Log log = LogFactory.getLog(TracingServiceComponent.class);
    private ServiceRegistration registration;

    @Activate
    protected void activate(ComponentContext componentContext) {
        try {
            log.debug((Object)"Tracing Component activated");
            BundleContext bundleContext = componentContext.getBundleContext();
            this.registration = bundleContext.registerService(OpenTracer.class, (Object)new JaegerTracer(), null);
            this.registration = bundleContext.registerService(OpenTracer.class, (Object)new ZipkinTracer(), null);
            this.registration = bundleContext.registerService(OpenTracer.class, (Object)new LogTracer(), null);
            this.registration = bundleContext.registerService(TracingService.class, (Object)TracingServiceImpl.getInstance(), null);
        }
        catch (Exception e) {
            log.error((Object)"Error occured in tracing component activation", (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        log.debug((Object)"Tracing Component deactivated");
        this.registration.unregister();
    }

    @Reference(name="api.manager.config.service", service=APIManagerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetAPIManagerConfigurationService")
    protected void setAPIManagerConfigurationService(APIManagerConfigurationService amcService) {
        ServiceReferenceHolder.getInstance().setAPIManagerConfigurationService(amcService);
    }

    protected void unsetAPIManagerConfigurationService(APIManagerConfigurationService amcService) {
        ServiceReferenceHolder.getInstance().setAPIManagerConfigurationService(null);
    }

    @Reference(name="opentracing.tracer.service", service=OpenTracer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetTracerService")
    protected void setTracerService(OpenTracer tracer) {
        ServiceReferenceHolder.getInstance();
        ServiceReferenceHolder.getOpenTracerMap().put(tracer.getName(), tracer);
    }

    protected void unsetTracerService(OpenTracer tracer) {
        ServiceReferenceHolder.getInstance();
        ServiceReferenceHolder.getOpenTracerMap().remove(tracer.getName());
    }
}

