/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.tracing.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.impl.APIManagerConfigurationService;
import org.wso2.carbon.apimgt.tracing.OpenTracer;
import org.wso2.carbon.apimgt.tracing.Util;
import org.wso2.carbon.apimgt.tracing.internal.TracingServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;

public class ServiceReferenceHolder {
    private static final Log log = LogFactory.getLog(TracingServiceComponent.class);
    private static final ServiceReferenceHolder instance = new ServiceReferenceHolder();
    private APIManagerConfiguration configuration = new APIManagerConfiguration();
    private static final String REMOTE_TRACER_ENABLED = "OpenTracer.RemoteTracer.Enabled";
    private static final String LOG_TRACER_ENABLED = "OpenTracer.LogTracer.Enabled";
    private static Map<String, OpenTracer> openTracerMap = new HashMap<String, OpenTracer>();

    private ServiceReferenceHolder() {
        try {
            String filePath = this.getFilePath();
            this.configuration.load(filePath);
            boolean remoteTracerEnabled = Boolean.parseBoolean(this.configuration.getFirstProperty(REMOTE_TRACER_ENABLED));
            boolean logTracerEnabled = Boolean.parseBoolean(this.configuration.getFirstProperty(LOG_TRACER_ENABLED));
            if (remoteTracerEnabled || logTracerEnabled) {
                Util.setTracingEnabled(true);
            }
        }
        catch (APIManagementException e) {
            log.error((Object)"Error in loading configurations", (Throwable)e);
        }
    }

    public static ServiceReferenceHolder getInstance() {
        return instance;
    }

    public APIManagerConfiguration getAPIManagerConfiguration() {
        return this.configuration;
    }

    private String getFilePath() {
        return CarbonUtils.getCarbonConfigDirPath() + File.separator + "api-manager.xml";
    }

    public void setAPIManagerConfigurationService(APIManagerConfigurationService amConfigService) {
    }

    public static Map<String, OpenTracer> getOpenTracerMap() {
        return openTracerMap;
    }
}

