/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.tracing;

import brave.Tracing;
import brave.opentracing.BraveTracer;
import brave.propagation.B3Propagation;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import io.opentracing.ScopeManager;
import io.opentracing.Tracer;
import io.opentracing.contrib.reporter.Reporter;
import io.opentracing.contrib.reporter.TracerR;
import io.opentracing.util.GlobalTracer;
import io.opentracing.util.ThreadLocalScopeManager;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.tracing.OpenTracer;
import org.wso2.carbon.apimgt.tracing.TracingReporter;
import org.wso2.carbon.apimgt.tracing.internal.ServiceReferenceHolder;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Sender;
import zipkin2.reporter.okhttp3.OkHttpSender;

public class ZipkinTracer
implements OpenTracer {
    private static final String NAME = "zipkin";
    private static APIManagerConfiguration configuration = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();

    @Override
    public Tracer getTracer(String serviceName) {
        String hostname = configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.HostName") != null ? configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.HostName") : "localhost";
        int port = configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.Port") != null ? Integer.parseInt(configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.Port")) : 9411;
        boolean tracerLogEnabled = Boolean.parseBoolean(configuration.getFirstProperty("OpenTracer.LogTracer.Enabled") != null ? configuration.getFirstProperty("OpenTracer.LogTracer.Enabled") : "false");
        OkHttpSender sender = OkHttpSender.create((String)("http://" + hostname + ":" + port + "/api/v2/spans"));
        BraveTracer tracer = BraveTracer.create((Tracing)Tracing.newBuilder().localServiceName(serviceName).spanReporter((zipkin2.reporter.Reporter)AsyncReporter.builder((Sender)sender).build()).propagationFactory(ExtraFieldPropagation.newFactory((Propagation.Factory)B3Propagation.FACTORY, (String[])new String[]{"request-id"})).build());
        if (tracerLogEnabled) {
            TracingReporter reporter = new TracingReporter(LogFactory.getLog((String)"tracer"));
            TracerR tracerR = new TracerR((Tracer)tracer, (Reporter)reporter, (ScopeManager)new ThreadLocalScopeManager());
            GlobalTracer.register((Tracer)tracerR);
            return tracerR;
        }
        GlobalTracer.register((Tracer)tracer);
        return tracer;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

