/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.tracing;

import com.google.common.collect.ImmutableMap;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.propagation.TextMapInjectAdapter;
import io.opentracing.util.GlobalTracer;
import java.util.Map;
import org.wso2.carbon.apimgt.tracing.TracingSpan;
import org.wso2.carbon.apimgt.tracing.TracingTracer;

public class Util {
    private static boolean isTraceEnabled = false;

    public static TracingSpan startSpan(String spanName, TracingSpan parentSpan, TracingTracer tracer) {
        if (parentSpan == null) {
            Span span = tracer.getTracingTracer().buildSpan(spanName).start();
            return new TracingSpan(span);
        }
        Object sp = parentSpan.getSpan();
        Span childSpan = sp != null ? (sp instanceof Span ? tracer.getTracingTracer().buildSpan(spanName).asChildOf((Span)sp).start() : tracer.getTracingTracer().buildSpan(spanName).asChildOf((SpanContext)sp).start()) : tracer.getTracingTracer().buildSpan(spanName).start();
        return new TracingSpan(childSpan);
    }

    public static void setTag(TracingSpan span, String key, String value) {
        Object sp = span.getSpan();
        if (sp instanceof Span) {
            ((Span)sp).setTag(key, value);
        }
    }

    public static void setLog(TracingSpan span, String key, String value) {
        Object sp = span.getSpan();
        if (sp instanceof Span) {
            ((Span)sp).log((Map)ImmutableMap.of((Object)key, (Object)value));
        }
    }

    public static void setLog(TracingSpan span, String key) {
        Object sp = span.getSpan();
        if (sp instanceof Span) {
            ((Span)sp).log(key);
        }
    }

    public static void finishSpan(TracingSpan span) {
        Object sp = span.getSpan();
        if (sp instanceof Span) {
            ((Span)sp).finish();
        }
    }

    public static void inject(TracingSpan span, TracingTracer tracer, Map<String, String> tracerSpecificCarrier) {
        Object sp = span.getSpan();
        if (sp instanceof Span) {
            tracer.getTracingTracer().inject(((Span)sp).context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMapInjectAdapter(tracerSpecificCarrier));
        } else if (sp instanceof SpanContext) {
            tracer.getTracingTracer().inject((SpanContext)sp, Format.Builtin.HTTP_HEADERS, (Object)new TextMapInjectAdapter(tracerSpecificCarrier));
        }
    }

    public static TracingSpan extract(TracingTracer tracer, Map<String, String> headerMap) {
        return new TracingSpan(tracer.getTracingTracer().extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(headerMap)));
    }

    public static TracingTracer getGlobalTracer() {
        return new TracingTracer(GlobalTracer.get());
    }

    public static void baggageSet(TracingSpan span, String key, String value) {
        Object sp = span.getSpan();
        if (sp instanceof Span) {
            ((Span)sp).setBaggageItem(key, value);
        }
    }

    public static String baggageGet(TracingSpan span, String key) {
        Object sp = span.getSpan();
        if (sp instanceof Span) {
            return ((Span)sp).getBaggageItem(key);
        }
        if (sp instanceof SpanContext) {
            Iterable entries = ((SpanContext)sp).baggageItems();
            for (Map.Entry entry : entries) {
                if (!((String)entry.getKey()).equals(key)) continue;
                return (String)entry.getValue();
            }
        }
        return null;
    }

    public static void setTracingEnabled(boolean isTraceEnabled) {
        Util.isTraceEnabled = isTraceEnabled;
    }

    public static boolean tracingEnabled() {
        return isTraceEnabled;
    }
}

