/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.tracing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.tracing.OpenTracer;
import org.wso2.carbon.apimgt.tracing.TracingService;
import org.wso2.carbon.apimgt.tracing.TracingTracer;
import org.wso2.carbon.apimgt.tracing.internal.ServiceReferenceHolder;

public class TracingServiceImpl
implements TracingService {
    private static final Log log = LogFactory.getLog(TracingServiceImpl.class);
    private static APIManagerConfiguration configuration = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();
    private static TracingServiceImpl instance = new TracingServiceImpl();
    private OpenTracer tracer;

    public static TracingServiceImpl getInstance() {
        return instance;
    }

    private TracingServiceImpl() {
        String openTracerName = configuration.getFirstProperty("OpenTracer.RemoteTracer.Name") != null ? configuration.getFirstProperty("OpenTracer.RemoteTracer.Name") : "zipkin";
        Boolean remoteTracerEnabled = Boolean.valueOf(configuration.getFirstProperty("OpenTracer.RemoteTracer.Enabled") != null ? configuration.getFirstProperty("OpenTracer.RemoteTracer.Enabled") : "false");
        String tracerName = openTracerName != null && remoteTracerEnabled != false ? openTracerName : "log";
        this.tracer = ServiceReferenceHolder.getOpenTracerMap().get(tracerName);
    }

    @Override
    public TracingTracer buildTracer(String serviceName) {
        return new TracingTracer(this.tracer.getTracer(serviceName));
    }
}

