/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.tracing;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.opentracing.contrib.reporter.LogLevel;
import io.opentracing.contrib.reporter.Reporter;
import io.opentracing.contrib.reporter.SpanData;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.apache.commons.logging.Log;

public class TracingReporter
implements Reporter {
    private final Log log;
    private final JsonFactory jsonFactory = new JsonFactory();

    public TracingReporter(Log log) {
        this.log = log;
    }

    public void start(Instant timeStamp, SpanData span) {
    }

    public void finish(Instant timeStamp, SpanData span) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)this.toStructuredMessage(timeStamp, span));
        }
    }

    public void log(Instant timeStamp, SpanData span, Map<String, ?> fields) {
        LogLevel level = LogLevel.INFO;
        LogLevel logLevel = (LogLevel)fields.get(LogLevel.FIELD_NAME);
        if (logLevel != null) {
            level = logLevel;
            fields.remove(LogLevel.FIELD_NAME);
        }
        switch (level) {
            case TRACE: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace((Object)this.toStructuredMessage(timeStamp, span));
                break;
            }
            case DEBUG: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)this.toStructuredMessage(timeStamp, span));
                break;
            }
            case WARN: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)this.toStructuredMessage(timeStamp, span));
                break;
            }
            case ERROR: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)this.toStructuredMessage(timeStamp, span));
                break;
            }
            default: {
                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)this.toStructuredMessage(timeStamp, span));
            }
        }
    }

    private String toStructuredMessage(Instant timeStamp, SpanData span) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = this.jsonFactory.createGenerator((Writer)writer);
            generator.writeStartObject();
            generator.writeNumberField("Latency", Duration.between(span.startAt, timeStamp).toMillis());
            generator.writeStringField("Operation", span.operationName);
            generator.writeObjectFieldStart("Tags");
            for (Map.Entry map : span.tags.entrySet()) {
                Object value = map.getValue();
                if (value instanceof String) {
                    generator.writeStringField((String)map.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Number) {
                    generator.writeNumberField((String)map.getKey(), ((Number)value).doubleValue());
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                generator.writeBooleanField((String)map.getKey(), ((Boolean)value).booleanValue());
            }
            generator.writeEndObject();
            generator.close();
            writer.close();
            return writer.toString();
        }
        catch (IOException e) {
            this.log.error((Object)"Error in structured message", (Throwable)e);
            return null;
        }
    }
}

