/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.tracing;

import io.jaegertracing.Configuration;
import io.opentracing.ScopeManager;
import io.opentracing.Tracer;
import io.opentracing.contrib.reporter.Reporter;
import io.opentracing.contrib.reporter.TracerR;
import io.opentracing.util.GlobalTracer;
import io.opentracing.util.ThreadLocalScopeManager;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.apimgt.impl.APIManagerConfiguration;
import org.wso2.carbon.apimgt.tracing.OpenTracer;
import org.wso2.carbon.apimgt.tracing.TracingReporter;
import org.wso2.carbon.apimgt.tracing.internal.ServiceReferenceHolder;

public class JaegerTracer
implements OpenTracer {
    private static final String NAME = "jaeger";
    private static APIManagerConfiguration configuration = ServiceReferenceHolder.getInstance().getAPIManagerConfiguration();

    @Override
    public Tracer getTracer(String serviceName) {
        String hostname = configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.HostName") != null ? configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.HostName") : "localhost";
        int port = configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.Port") != null ? Integer.parseInt(configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.Port")) : 5775;
        String samplerType = configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.SamplerType") != null ? configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.SamplerType") : "const";
        float samplerParam = configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.SamplerParam") != null ? Float.parseFloat(configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.SamplerParam")) : 1.0f;
        int reporterFlushInterval = configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.ReporterFlushInterval") != null ? Integer.parseInt(configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.ReporterFlushInterval")) : 1000;
        int reporterBufferSize = configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.ReporterBufferSize") != null ? Integer.parseInt(configuration.getFirstProperty("OpenTracer.RemoteTracer.Properties.ReporterBufferSize")) : 1000;
        boolean tracerLogEnabled = Boolean.parseBoolean(configuration.getFirstProperty("OpenTracer.LogTracer.Enabled") != null ? configuration.getFirstProperty("OpenTracer.LogTracer.Enabled") : "false");
        Configuration.SamplerConfiguration samplerConfig = new Configuration.SamplerConfiguration().withType(samplerType).withParam((Number)Float.valueOf(samplerParam));
        Configuration.SenderConfiguration senderConfig = new Configuration.SenderConfiguration().withAgentHost(hostname).withAgentPort(Integer.valueOf(port));
        Configuration.ReporterConfiguration reporterConfig = new Configuration.ReporterConfiguration().withLogSpans(Boolean.valueOf(true)).withFlushInterval(Integer.valueOf(reporterFlushInterval)).withMaxQueueSize(Integer.valueOf(reporterBufferSize)).withSender(senderConfig);
        io.jaegertracing.internal.JaegerTracer tracer = new Configuration(serviceName).withSampler(samplerConfig).withReporter(reporterConfig).getTracer();
        if (tracerLogEnabled) {
            TracingReporter reporter = new TracingReporter(LogFactory.getLog((String)"tracer"));
            TracerR tracerR = new TracerR((Tracer)tracer, (Reporter)reporter, (ScopeManager)new ThreadLocalScopeManager());
            GlobalTracer.register((Tracer)tracerR);
            return tracerR;
        }
        GlobalTracer.register((Tracer)tracer);
        return tracer;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

