/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.reporter;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.reporter.Reporter;
import io.opentracing.contrib.reporter.SpanData;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SpanR
extends SpanData
implements Span {
    private Span wrapped;
    private final Reporter reporter;

    public SpanR(Span wrapped, Reporter reporter, String spanId, String operationName, Map<String, Object> tags, Map<String, String> references) {
        this.reporter = reporter;
        this.wrapped = wrapped;
        this.spanId = spanId;
        this.operationName = operationName;
        this.tags = new ConcurrentHashMap<String, Object>(tags);
        this.references = Collections.unmodifiableMap(references);
        this.startAt = this.now();
        reporter.start(this.startAt, this);
    }

    protected Instant now() {
        return Instant.now();
    }

    protected Instant ts(long timestampMicroSeconds) {
        return Instant.ofEpochMilli(timestampMicroSeconds / 1000L);
    }

    @Override
    public SpanContext context() {
        return this.wrapped.context();
    }

    @Override
    public void finish() {
        this.wrapped.finish();
        this.reporter.finish(this.now(), this);
    }

    @Override
    public void finish(long l) {
        this.wrapped.finish(l);
        this.reporter.finish(this.ts(l), this);
    }

    @Override
    public Span setTag(String s, boolean b) {
        this.wrapped = this.wrapped.setTag(s, b);
        this.tags.put(s, b);
        return this;
    }

    @Override
    public Span setTag(String s, String s1) {
        this.wrapped = this.wrapped.setTag(s, s1);
        this.tags.put(s, s1);
        return this;
    }

    @Override
    public Span setTag(String s, Number number) {
        this.wrapped = this.wrapped.setTag(s, number);
        this.tags.put(s, number);
        return this;
    }

    @Override
    public Span log(Map<String, ?> map) {
        this.wrapped = this.wrapped.log(map);
        this.toLogger(this.now(), map);
        return this;
    }

    @Override
    public Span log(long l, Map<String, ?> map) {
        this.wrapped = this.wrapped.log(l, map);
        this.toLogger(this.ts(l), map);
        return this;
    }

    @Override
    public Span log(String event) {
        this.wrapped = this.wrapped.log(event);
        this.toLogger(this.now(), Collections.singletonMap("event", event));
        return this;
    }

    @Override
    public Span log(long l, String event) {
        this.wrapped.log(l, event);
        this.toLogger(this.ts(l), Collections.singletonMap("event", event));
        return this;
    }

    @Override
    public Span setBaggageItem(String s, String s1) {
        this.wrapped = this.wrapped.setBaggageItem(s, s1);
        return this;
    }

    @Override
    public String getBaggageItem(String s) {
        return this.wrapped.getBaggageItem(s);
    }

    @Override
    public SpanR setOperationName(String s) {
        this.wrapped = this.wrapped.setOperationName(s);
        this.operationName = s;
        return this;
    }

    protected void toLogger(Instant ts, Map<String, ?> map) {
        this.reporter.log(ts, this, map);
    }
}

