/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.reporter;

import io.opentracing.contrib.reporter.Reporter;
import io.opentracing.contrib.reporter.SpanData;
import java.time.Instant;
import java.util.Map;

public class CompositeReporter
implements Reporter {
    private final Reporter[] reporters;

    public CompositeReporter(Reporter ... reporters) {
        this.reporters = reporters;
    }

    @Override
    public void start(Instant ts, SpanData span) {
        for (Reporter r : this.reporters) {
            try {
                r.start(ts, span);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    @Override
    public void finish(Instant ts, SpanData span) {
        for (Reporter r : this.reporters) {
            try {
                r.finish(ts, span);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    @Override
    public void log(Instant ts, SpanData span, Map<String, ?> fields) {
        for (Reporter r : this.reporters) {
            try {
                r.log(ts, span, fields);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }
}

