/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.InternalPropagation;
import brave.internal.Nullable;
import brave.internal.TraceContexts;
import brave.propagation.TraceContext;
import java.util.List;

public class SamplingFlags {
    public static final SamplingFlags EMPTY = new SamplingFlags(0);
    public static final SamplingFlags NOT_SAMPLED = new SamplingFlags(4);
    public static final SamplingFlags SAMPLED = new SamplingFlags(SamplingFlags.NOT_SAMPLED.flags | 2);
    public static final SamplingFlags DEBUG = new SamplingFlags(SamplingFlags.SAMPLED.flags | 8);
    final int flags;

    public SamplingFlags build() {
        return this.flags == 0 ? EMPTY : (SamplingFlags.debug(this.flags) ? DEBUG : ((this.flags & 2) == 2 ? SAMPLED : NOT_SAMPLED));
    }

    SamplingFlags(int flags) {
        this.flags = flags;
    }

    @Nullable
    public final Boolean sampled() {
        return (this.flags & 4) == 4 ? Boolean.valueOf((this.flags & 2) == 2) : null;
    }

    public final boolean debug() {
        return SamplingFlags.debug(this.flags);
    }

    public String toString() {
        return "SamplingFlags(sampled=" + this.sampled() + ", debug=" + this.debug() + ")";
    }

    static boolean debug(int flags) {
        return (flags & 8) == 8;
    }

    static int debug(boolean debug, int flags) {
        flags = debug ? (flags |= 0xE) : (flags &= 0xFFFFFFF7);
        return flags;
    }

    static {
        InternalPropagation.instance = new InternalPropagation(){

            @Override
            public int flags(SamplingFlags flags) {
                return flags.flags;
            }

            @Override
            public TraceContext newTraceContext(int flags, long traceIdHigh, long traceId, long parentId, long spanId, List<Object> extra) {
                return new TraceContext(flags, traceIdHigh, traceId, parentId, spanId, extra);
            }
        };
    }

    @Deprecated
    public static final class Builder {
        int flags = 0;

        public Builder sampled(@Nullable Boolean sampled) {
            if (sampled == null) {
                this.flags &= 0xFFFFFFF9;
                return this;
            }
            this.flags = TraceContexts.sampled(sampled, this.flags);
            return this;
        }

        public Builder debug(boolean debug) {
            this.flags = SamplingFlags.debug(debug, this.flags);
            return this;
        }

        public static SamplingFlags build(@Nullable Boolean sampled) {
            if (sampled != null) {
                return sampled != false ? SAMPLED : NOT_SAMPLED;
            }
            return EMPTY;
        }

        public SamplingFlags build() {
            return this.flags == 0 ? EMPTY : (SamplingFlags.debug(this.flags) ? DEBUG : ((this.flags & 2) == 2 ? SAMPLED : NOT_SAMPLED));
        }
    }
}

