/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Clock;
import brave.internal.Nullable;
import brave.internal.recorder.MutableSpan;
import brave.internal.recorder.MutableSpanConverter;
import brave.internal.recorder.PendingSpan;
import brave.internal.recorder.TickClock;
import brave.propagation.TraceContext;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public final class PendingSpans
extends ReferenceQueue<TraceContext> {
    final ConcurrentMap<Object, PendingSpan> delegate = new ConcurrentHashMap<Object, PendingSpan>(64);
    final Endpoint localEndpoint;
    final Clock clock;
    final Reporter<Span> reporter;
    final AtomicBoolean noop;
    static final ThreadLocal<LookupKey> LOOKUP_KEY = new ThreadLocal();

    public PendingSpans(Endpoint localEndpoint, Clock clock, Reporter<Span> reporter, AtomicBoolean noop) {
        this.localEndpoint = localEndpoint;
        this.clock = clock;
        this.reporter = reporter;
        this.noop = noop;
    }

    @Nullable
    PendingSpan get(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        this.reportOrphanedSpans();
        LookupKey lookupKey = PendingSpans.getLookupKey();
        lookupKey.set(context);
        return (PendingSpan)this.delegate.get(lookupKey);
    }

    public PendingSpan getOrCreate(TraceContext context, boolean start) {
        PendingSpan newSpan;
        PendingSpan previousSpan;
        TickClock clock;
        PendingSpan result = this.get(context);
        if (result != null) {
            return result;
        }
        MutableSpan data = new MutableSpan();
        if (context.shared()) {
            data.setShared();
        }
        if ((clock = this.getClockFromParent(context)) == null) {
            clock = new TickClock(this.clock.currentTimeMicroseconds(), System.nanoTime());
            if (start) {
                data.startTimestamp(clock.baseEpochMicros);
            }
        } else if (start) {
            data.startTimestamp(clock.currentTimeMicroseconds());
        }
        if ((previousSpan = this.delegate.putIfAbsent(new RealKey(context, this), newSpan = new PendingSpan(data, clock))) != null) {
            return previousSpan;
        }
        return newSpan;
    }

    @Nullable
    TickClock getClockFromParent(TraceContext context) {
        long parentId = context.parentIdAsLong();
        PendingSpan parent = null;
        if (context.shared() || parentId != 0L) {
            LookupKey lookupKey = PendingSpans.getLookupKey();
            long spanId = parentId != 0L ? parentId : context.spanId();
            lookupKey.set(context.traceIdHigh(), context.traceId(), spanId, false);
            parent = (PendingSpan)this.delegate.get(lookupKey);
        }
        return parent != null ? parent.clock : null;
    }

    public boolean remove(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        LookupKey lookupKey = PendingSpans.getLookupKey();
        lookupKey.set(context);
        PendingSpan last = (PendingSpan)this.delegate.remove(lookupKey);
        this.reportOrphanedSpans();
        return last != null;
    }

    void reportOrphanedSpans() {
        RealKey contextKey;
        Span.Builder builder = null;
        long flushTime = 0L;
        while ((contextKey = (RealKey)this.poll()) != null) {
            PendingSpan value = (PendingSpan)this.delegate.remove(contextKey);
            if (value == null || this.noop.get() || !contextKey.sampled) continue;
            if (builder != null) {
                builder.clear();
            } else {
                builder = Span.newBuilder();
                flushTime = this.clock.currentTimeMicroseconds();
            }
            Span.Builder builderWithContextData = Span.newBuilder().traceId(contextKey.traceIdHigh, contextKey.traceId).id(contextKey.spanId).localEndpoint(this.localEndpoint).addAnnotation(flushTime, "brave.flush");
            MutableSpanConverter.convert(value.state, builderWithContextData);
            this.reporter.report((Object)builderWithContextData.build());
        }
    }

    public List<Span> snapshot() {
        ArrayList<Span> result = new ArrayList<Span>();
        Span.Builder spanBuilder = Span.newBuilder();
        for (Map.Entry entry : this.delegate.entrySet()) {
            RealKey contextKey = (RealKey)entry.getKey();
            spanBuilder.clear().traceId(contextKey.traceIdHigh, contextKey.traceId).id(contextKey.spanId);
            MutableSpanConverter.convert(((PendingSpan)entry.getValue()).state, spanBuilder);
            result.add(spanBuilder.build());
            spanBuilder.clear();
        }
        return result;
    }

    public String toString() {
        return "PendingSpans" + this.delegate.keySet();
    }

    static LookupKey getLookupKey() {
        LookupKey lookupKey = LOOKUP_KEY.get();
        if (lookupKey == null) {
            lookupKey = new LookupKey();
            LOOKUP_KEY.set(lookupKey);
        }
        return lookupKey;
    }

    static final class LookupKey {
        long traceIdHigh;
        long traceId;
        long spanId;
        boolean shared;
        int hashCode;

        LookupKey() {
        }

        void set(TraceContext context) {
            this.set(context.traceIdHigh(), context.traceId(), context.spanId(), context.shared());
        }

        void set(long traceIdHigh, long traceId, long spanId, boolean shared) {
            this.traceIdHigh = traceIdHigh;
            this.traceId = traceId;
            this.spanId = spanId;
            this.shared = shared;
            this.hashCode = LookupKey.generateHashCode(traceIdHigh, traceId, spanId, shared);
        }

        public int hashCode() {
            return this.hashCode;
        }

        static int generateHashCode(long traceIdHigh, long traceId, long spanId, boolean shared) {
            int h = 1;
            h *= 1000003;
            h ^= (int)(traceIdHigh >>> 32 ^ traceIdHigh);
            h *= 1000003;
            h ^= (int)(traceId >>> 32 ^ traceId);
            h *= 1000003;
            h ^= (int)(spanId >>> 32 ^ spanId);
            h *= 1000003;
            return h ^= shared ? 16 : 0;
        }

        public boolean equals(Object other) {
            RealKey that = (RealKey)other;
            TraceContext thatContext = (TraceContext)that.get();
            if (thatContext == null) {
                return false;
            }
            return this.traceIdHigh == thatContext.traceIdHigh() && this.traceId == thatContext.traceId() && this.spanId == thatContext.spanId() && this.shared == thatContext.shared();
        }
    }

    static final class RealKey
    extends WeakReference<TraceContext> {
        final int hashCode;
        final long traceIdHigh;
        final long traceId;
        final long spanId;
        final boolean sampled;

        RealKey(TraceContext context, ReferenceQueue<TraceContext> queue) {
            super(context, queue);
            this.hashCode = context.hashCode();
            this.traceIdHigh = context.traceIdHigh();
            this.traceId = context.traceId();
            this.spanId = context.spanId();
            this.sampled = Boolean.TRUE.equals(context.sampled());
        }

        public String toString() {
            TraceContext context = (TraceContext)this.get();
            return context != null ? "WeakReference(" + context + ")" : "ClearedReference()";
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            TraceContext thisContext = (TraceContext)this.get();
            TraceContext thatContext = (TraceContext)((RealKey)other).get();
            if (thisContext == null) {
                return thatContext == null;
            }
            return thisContext.equals(thatContext);
        }
    }
}

